/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class WatchlistData
implements Serializable {
    private static final long serialVersionUID = 100216L;
    private String name;
    private String id;
    public List<WatchlistData> subWatches;
    private List<String> symbolList;
    private boolean isTicker;
    private String pid;

    public WatchlistData(String name, String id, String pid, boolean isTicker) {
        this.name = name;
        this.id = id;
        this.pid = pid;
        this.isTicker = isTicker;
    }

    public WatchlistData() {
    }

    public String getParentID() {
        return this.pid;
    }

    public void setParentID(String pid) {
        this.pid = pid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<WatchlistData> getSubWatches() {
        if (this.subWatches == null) {
            return null;
        }
        Collections.sort(this.subWatches, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                WatchlistData w1 = (WatchlistData)arg0;
                WatchlistData w2 = (WatchlistData)arg1;
                if (w1.hasChild()) {
                    return 1;
                }
                if (w2.hasChild()) {
                    return -1;
                }
                return ((WatchlistData)arg0).getName().compareTo(((WatchlistData)arg1).getName());
            }
        });
        return new ArrayList<WatchlistData>(this.subWatches);
    }

    public void setSubWatches(List<WatchlistData> subWatches) {
        this.subWatches = subWatches;
    }

    public void addSubWatches(List<WatchlistData> subWatches) {
        if (subWatches != null) {
            if (this.subWatches == null) {
                this.subWatches = new ArrayList<WatchlistData>();
            }
            this.subWatches.addAll(subWatches);
        } else {
            System.out.println("Error : Null watchlist could not be added");
        }
    }

    public void addSubWatch(WatchlistData subWatch) {
        if (subWatch != null) {
            if (this.subWatches == null) {
                this.subWatches = new ArrayList<WatchlistData>();
            }
            this.subWatches.add(subWatch);
        } else {
            System.out.println("Error : Null watchlist could not be added");
        }
    }

    public boolean hasChild() {
        return this.subWatches != null && !this.subWatches.isEmpty();
    }

    public List<String> getSymbolList() {
        return this.symbolList;
    }

    public void setSymbolList(List<String> symbolList) {
        this.symbolList = symbolList;
    }

    public void setTicker(boolean isTicker) {
        this.isTicker = isTicker;
    }

    public boolean isTicker() {
        return this.isTicker;
    }

    public String toString() {
        String temp = "";
        List<WatchlistData> lst = this.getSubWatches();
        if (lst != null) {
            int i = 0;
            while (i < lst.size()) {
                temp = String.valueOf(temp) + "  " + lst.get(i).toString();
                ++i;
            }
        }
        return "WatchlistData [name=" + this.name + ", id=" + this.id + " SubMenu = " + (lst == null ? 0 : lst.size()) + " , Symbols = " + (this.symbolList == null ? 0 : this.symbolList.size()) + " , IsTicker " + this.isTicker + " ]\n" + temp;
    }

    public String toXML() {
        return "WatchlistData [name=" + this.name + ", id=" + this.id + " , Symbols = " + (this.symbolList == null ? 0 : this.symbolList.size()) + "]";
    }
}

