/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import pk.com.softech.tradingterminal.core.db.Security;

public class Vwap {
    private String symbol = "";
    private double price = 0.0;
    private int volume = 0;
    private double typicalPrice = 0.0;
    private double priceMulvol = 0.0;
    private double sumPriceMulvol = 0.0;
    private double sumVol = 0.0;
    private double vWapVal = 0.0;

    public void updateByTypicalPrice(Security s) {
        try {
            double newPrice = 0.0;
            if (s.getHigh() != null && s.getHigh() != 0.0 && s.getLow() != 0.0 && s.getLow() != null) {
                newPrice = (s.getQuote().getLast() + s.getHigh() + s.getLow()) / 3.0;
            } else if (s.getQuote().getLast() != 0.0) {
                newPrice = s.getQuote().getLast();
            }
            if (newPrice != 0.0 && s.getQuote().getVolume() != 0L) {
                this.price += newPrice;
            }
            if (s.getQuote().getVolume() != 0L && newPrice != 0.0) {
                this.volume += (int)s.getQuote().getVolume();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateByPreviousFeed(Security newSec) {
        try {
            int tempVol = (int)newSec.getQuote().getVolume();
            double tempPrice = newSec.getQuote().getLast();
            double tempHigh = newSec.getHigh();
            double tempLow = newSec.getLow();
            this.symbol = newSec.getSymbol();
            this.price = tempPrice;
            this.volume = tempVol;
            if (tempHigh == 0.0 || tempLow == 0.0) {
                // empty if block
            }
            this.priceMulvol = tempPrice != 0.0 && tempVol != 0 ? tempPrice * (double)tempVol : 0.0;
            this.sumPriceMulvol += this.priceMulvol;
            this.sumVol += (double)tempVol;
            this.vWapVal = this.sumVol > 0.0 ? this.sumPriceMulvol / this.sumVol : 0.0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public double getAverage() {
        double avg = 0.0;
        if (this.price > 0.0 && this.volume > 0) {
            avg = this.price * (double)this.volume / (double)this.volume;
        }
        return avg;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
    }

    public double getPriceMulvol() {
        return this.priceMulvol;
    }

    public void setPriceMulvol(double priceMulvol) {
    }

    public double getSumPriceMulvol() {
        return this.sumPriceMulvol;
    }

    public void setSumPriceMulvol(double sumPriceMulvol) {
    }

    public double getSumVol() {
        return this.sumVol;
    }

    public void setSumVol(double sumVol) {
    }

    public double getvWapVal() {
        return this.vWapVal;
    }

    public void setvWapVal(double vWapVal) {
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
    }

    public int getVolume() {
        return this.volume;
    }

    public void setVolume(Integer volume) {
        volume = (int)volume;
    }

    public double getTypicalPrice() {
        return this.typicalPrice;
    }

    public void setTypicalPrice(double typicalPrice) {
    }
}

