/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import java.util.Date;
import pk.com.softech.messages.Message;
import pk.com.softech.messages.OrderMessage;

public class TradeMessage
extends Message {
    private static final long serialVersionUID = 100085L;
    public static final int REGULAR = 1;
    public static final int SPOT = 2;
    public static final int COT = 3;
    public static final int RELEASE = 4;
    public static final int ODL = 5;
    public static final int FUT = 6;
    public static final int PRV = 7;
    protected OrderMessage buyer;
    protected OrderMessage seller;
    protected float rate;
    protected float closePrice;
    protected int volume;
    protected String tradeNumber;
    protected int tradeType;
    protected int orderVolume;
    protected int executedVolume;
    public static final String TAG_buyer = "BYR";
    public static final String TAG_seller = "SLR";
    public static final String TAG_rate = "RTE";
    public static final String TAG_volume = "VOL";
    public static final String TAG_tradeNumber = "TNO";
    public static final String TAG_tradeType = "TTY";

    public TradeMessage(OrderMessage buyer, OrderMessage seller, float rate, int volume, String tradeNumber, int type, float closePrice) {
        super(12);
        this.setBuyer(buyer);
        this.setSeller(seller);
        this.setRate(rate);
        this.setVolume(volume);
        this.setTradeNumber(tradeNumber);
        this.setTradeType(type);
        this.setClosePrice(closePrice);
    }

    public TradeMessage(OrderMessage buyer, OrderMessage seller, float rate, int volume, String tradeNumber, int type) {
        this(buyer, seller, rate, volume, tradeNumber, type, 0.0f);
    }

    public TradeMessage(OrderMessage buyer, OrderMessage seller, float rate, int volume, String tradeNumber, int type, Date timeStamp, float closePrice) {
        this(buyer, seller, rate, volume, tradeNumber, type, closePrice);
        this.setTimeStamp(timeStamp);
    }

    public TradeMessage(OrderMessage buyer, OrderMessage seller, float rate, int volume, String tradeNumber, int type, Date timeStamp) {
        this(buyer, seller, rate, volume, tradeNumber, type, 0.0f);
        this.setTimeStamp(timeStamp);
    }

    public TradeMessage(TradeMessage oldTrade) {
        super(12);
        this.setBuyer(oldTrade.getBuyer());
        this.setSeller(oldTrade.getSeller());
        this.setRate(oldTrade.getRate());
        this.setVolume(oldTrade.getVolume());
        this.setTradeNumber(oldTrade.getTradeNumber());
        this.setTradeType(oldTrade.getTradeType());
        this.setTimeStamp(new Date(oldTrade.getTimeStamp().getTime()));
        this.setClosePrice(oldTrade.getClosePrice());
        this.setOrderVolume(oldTrade.getOrderVolume());
        this.setExecutedVolume(oldTrade.getExecutedVolume());
    }

    public TradeMessage() {
        super(12);
    }

    public void setBuyer(OrderMessage buyer) {
        if (buyer == null) {
            throw new IllegalArgumentException();
        }
        this.buyer = new OrderMessage(buyer);
    }

    public OrderMessage getBuyer() {
        return this.buyer;
    }

    public void setSeller(OrderMessage seller) {
        if (seller == null) {
            throw new IllegalArgumentException("Seller cannot be null.");
        }
        this.seller = new OrderMessage(seller);
    }

    public void setTradeType(int type) {
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.tradeType = type;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid trade type.");
            }
        }
    }

    public OrderMessage getSeller() {
        return this.seller;
    }

    public void setRate(float rate) {
        this.rate = rate;
    }

    public float getRate() {
        return this.rate;
    }

    public void setVolume(int volume) {
        this.volume = volume;
    }

    public int getVolume() {
        return this.volume;
    }

    public void setTradeNumber(String tradeNumber) {
        this.tradeNumber = tradeNumber;
    }

    public String getTradeNumber() {
        return this.tradeNumber;
    }

    public int getTradeType() {
        return this.tradeType;
    }

    public void setClosePrice(float closePrice) {
        this.closePrice = closePrice;
    }

    public float getClosePrice() {
        return this.closePrice;
    }

    public int getOrderVolume() {
        return this.orderVolume;
    }

    public void setOrderVolume(int orderVolume) {
        this.orderVolume = orderVolume;
    }

    public int getExecutedVolume() {
        return this.executedVolume;
    }

    public void setExecutedVolume(int executedVolume) {
        this.executedVolume = executedVolume;
    }

    @Override
    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"TradeMessage\">");
        if (this.buyer != null) {
            xml.append("<BYR>" + this.buyer.toXML() + "</" + TAG_buyer + ">");
        }
        if (this.seller != null) {
            xml.append("<SLR>" + this.seller.toXML() + "</" + TAG_seller + ">");
        }
        xml.append("<RTE>" + this.rate + "</" + TAG_rate + ">" + "<" + TAG_volume + ">" + this.volume + "</" + TAG_volume + ">");
        if (this.tradeNumber != null && !this.tradeNumber.equals("")) {
            xml.append("<TNO><![CDATA[" + this.tradeNumber + "]]>" + "</" + TAG_tradeNumber + ">");
        }
        xml.append("<TTY>" + this.tradeType + "</" + TAG_tradeType + ">" + "</Class>");
        return xml.toString();
    }

    public String toString() {
        return "TradeMessage [buyer=" + this.buyer + ", seller=" + this.seller + ", rate=" + this.rate + ", closePrice=" + this.closePrice + ", volume=" + this.volume + ", tradeNumber=" + this.tradeNumber + ", tradeType=" + this.tradeType + "]";
    }
}

