/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import pk.com.softech.messages.OrderMessage;

public class TradeData
implements Serializable {
    private static final long serialVersionUID = 100081L;
    protected String number;
    protected int orderNumber;
    protected Date timeStamp;
    protected String market;
    protected String symbol;
    protected float price;
    protected String buyClient;
    protected int buyOrderNumber;
    protected String sellClient;
    protected int sellOrderNumber;
    protected int volume;
    protected int side;
    protected String refNumber;
    protected Date tradeTime;
    protected String clientUIN;
    protected int orderOrgVol;
    protected String exchangeCode;
    protected String orderNature;
    public static final String TAG_number = "NUM";
    public static final String TAG_orderNumber = "ONM";
    public static final String TAG_timeStamp = "TST";
    public static final String TAG_market = "MKT";
    public static final String TAG_symbol = "SYM";
    public static final String TAG_price = "PRC";
    public static final String TAG_buyClient = "BCL";
    public static final String TAG_buyOrderNumber = "BON";
    public static final String TAG_sellClient = "SCL";
    public static final String TAG_sellOrderNumber = "SON";
    public static final String TAG_volume = "VOL";
    public static final String TAG_side = "SDE";
    public static final String TAG_refNumber = "REF";
    public static final String TAG_tradeTime = "TTS";
    public static final String TAG_clientUIN = "CUI";
    public static final String TAG_orderOrgVol = "OOV";
    public static final String TAG_exchangeCode = "EXC";

    public TradeData(String number, int orderNumber, Date timeStamp, String market, String symbol, float price, String buyClient, int buyOrderNumber, String sellClient, int sellOrderNumber, int volume, int side, String refNumber, Date tradeTime, String clientUIN, int orderOrgVol, String stExCode, String orderNature) {
        this.setNumber(number);
        this.setOrderNumber(orderNumber);
        this.setTimeStamp(timeStamp);
        this.setMarket(market);
        this.setSymbol(symbol);
        this.setPrice(price);
        this.setBuyClient(buyClient);
        this.setBuyOrderNumber(buyOrderNumber);
        this.setSellClient(sellClient);
        this.setSellOrderNumber(sellOrderNumber);
        this.setVolume(volume);
        this.setSide(side);
        this.setRefNumber(refNumber);
        this.setTradeTime(tradeTime);
        this.setClientUIN(clientUIN);
        this.setOriginalOrderVolume(orderOrgVol);
        this.setExchangeCode(stExCode);
        this.setOrderNature(orderNature);
    }

    public TradeData() {
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public void setOrderNumber(int orderNumber) {
        this.orderNumber = orderNumber;
    }

    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void setMarket(String market) {
        this.market = market;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public void setPrice(float price) {
        this.price = price;
    }

    public void setBuyClient(String buyClient) {
        this.buyClient = buyClient;
    }

    public void setBuyOrderNumber(int buyOrderNumber) {
        this.buyOrderNumber = buyOrderNumber;
    }

    public void setSellClient(String sellClient) {
        this.sellClient = sellClient;
    }

    public void setSellOrderNumber(int sellOrderNumber) {
        this.sellOrderNumber = sellOrderNumber;
    }

    public void setVolume(int volume) {
        this.volume = volume;
    }

    public void setClientUIN(String clientUIN) {
        this.clientUIN = clientUIN;
    }

    public void setOriginalOrderVolume(int orderOrgVol) {
        this.orderOrgVol = orderOrgVol;
    }

    public void setSide(int side) {
        if (side != 0 && side != 1 && side != 4) {
            throw new IllegalArgumentException("Invalid order side, should be either BID or OFFER.");
        }
        this.side = side;
    }

    public String getNumber() {
        return this.number;
    }

    public int getOrderNumber() {
        return this.orderNumber;
    }

    public String getMarket() {
        return this.market;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public int getSide() {
        return this.side;
    }

    public String getSideName() {
        return OrderMessage.sideNames[this.side];
    }

    public float getPrice() {
        return this.price;
    }

    public String getBuyClient() {
        return this.buyClient;
    }

    public int getBuyOrderNumber() {
        return this.buyOrderNumber;
    }

    public String getSellClient() {
        return this.sellClient;
    }

    public int getSellOrderNumber() {
        return this.sellOrderNumber;
    }

    public int getVolume() {
        return this.volume;
    }

    public void setRefNumber(String refNumber) {
        this.refNumber = refNumber;
    }

    public String getRefNumber() {
        return this.refNumber;
    }

    public void setTradeTime(Date tradeTime) {
        this.tradeTime = tradeTime;
    }

    public Date getTradeTime() {
        return this.tradeTime;
    }

    public String getclientUIN() {
        return this.clientUIN;
    }

    public int getOriginalOrderVolume() {
        return this.orderOrgVol;
    }

    public String getExchangeCode() {
        return this.exchangeCode;
    }

    public void setExchangeCode(String exchangeCode) {
        this.exchangeCode = exchangeCode;
    }

    public String getOrderNature() {
        return this.orderNature;
    }

    public void setOrderNature(String orderNature) {
        this.orderNature = orderNature;
    }

    public String toXML() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        dateFormat.setLenient(false);
        StringBuffer xml = new StringBuffer("<Class name=\"TradeData\">");
        if (this.number != null && !this.number.equals("")) {
            xml.append("<NUM><![CDATA[" + this.number + "]]>" + "</" + TAG_number + ">");
        }
        xml.append("<ONM>" + this.orderNumber + "</" + TAG_orderNumber + ">" + "<" + TAG_timeStamp + ">" + dateFormat.format(this.timeStamp) + "</" + TAG_timeStamp + ">");
        if (this.market != null && !this.market.equals("")) {
            xml.append("<MKT><![CDATA[" + this.market + "]]>" + "</" + TAG_market + ">");
        }
        if (this.symbol != null && !this.symbol.equals("")) {
            xml.append("<SYM><![CDATA[" + this.symbol + "]]>" + "</" + TAG_symbol + ">");
        }
        xml.append("<PRC>" + this.price + "</" + TAG_price + ">");
        if (this.buyClient != null && !this.buyClient.equals("")) {
            xml.append("<BCL><![CDATA[" + this.buyClient + "]]>" + "</" + TAG_buyClient + ">");
        }
        xml.append("<BON>" + this.buyOrderNumber + "</" + TAG_buyOrderNumber + ">");
        if (this.sellClient != null && !this.sellClient.equals("")) {
            xml.append("<SCL><![CDATA[" + this.sellClient + "]]>" + "</" + TAG_sellClient + ">");
        }
        xml.append("<SON>" + this.sellOrderNumber + "</" + TAG_sellOrderNumber + ">" + "<" + TAG_volume + ">" + this.volume + "</" + TAG_volume + ">" + "<" + TAG_side + ">" + this.side + "</" + TAG_side + ">" + "<" + TAG_refNumber + ">" + this.refNumber + "</" + TAG_refNumber + ">" + "<" + TAG_tradeTime + ">" + this.tradeTime + "</" + TAG_tradeTime + ">" + "<" + TAG_clientUIN + ">" + this.clientUIN + "</" + TAG_clientUIN + ">" + "<" + TAG_orderOrgVol + ">" + this.orderOrgVol + "</" + TAG_orderOrgVol + ">" + "<" + TAG_exchangeCode + ">" + this.exchangeCode + "</" + TAG_exchangeCode + ">" + "</Class>");
        return xml.toString();
    }
}

