/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import java.text.SimpleDateFormat;
import java.util.Date;
import pk.com.softech.messages.Message;
import pk.com.softech.messages.OrderMessage;
import pk.com.softech.messages.TradeMessage;

public class TradeConfirmation
extends Message {
    private static final long serialVersionUID = 100080L;
    public static final int BID = 0;
    public static final int OFFER = 1;
    public static final int CROSS = 2;
    public static final String[] sideNames = new String[]{"Bought", "Sold", "Cross"};
    public static final String INVALID_SIDE = "Invalid trade side, should be either BID or OFFER.";
    protected TradeMessage trade;
    protected String remarks;
    protected int side;
    public static final String TAG_trade = "TRD";
    public static final String TAG_remarks = "RMK";
    public static final String TAG_side = "SDE";
    public static final String TAG_timeStamp = "TST";

    public TradeConfirmation(TradeMessage trade, int side, String remarks) {
        super(112);
        this.setTrade(trade);
        this.setSide(side);
        this.setRemarks(remarks);
    }

    public TradeConfirmation(TradeMessage trade, int side, String remarks, Date timeStamp) {
        this(trade, side, remarks);
        this.setTimeStamp(timeStamp);
    }

    public TradeConfirmation() {
        super(112);
    }

    public void setTrade(TradeMessage trade) {
        this.trade = new TradeMessage(trade);
    }

    public TradeMessage getTrade() {
        return this.trade;
    }

    public void setSide(int side) {
        if (side != 0 && side != 1 && side != 2) {
            throw new IllegalArgumentException(INVALID_SIDE);
        }
        this.side = side;
    }

    public int getSide() {
        return this.side;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public OrderMessage getHouseOrder() {
        if (this.getSide() == 0) {
            return this.getTrade().getBuyer();
        }
        return this.getTrade().getSeller();
    }

    public void setHouseOrder(OrderMessage order) {
        if (this.getSide() == 0) {
            this.getTrade().setBuyer(order);
        } else {
            this.getTrade().setSeller(order);
        }
    }

    public String buildMessage() {
        return this.getRemarks();
    }

    public String formatString() {
        return "TC|" + this.buildMessage();
    }

    @Override
    public String toXML() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        dateFormat.setLenient(false);
        StringBuffer xml = new StringBuffer("<Class name=\"TradeConfirmation\">");
        if (this.trade != null) {
            xml.append("<TRD>" + this.trade.toXML() + "</" + TAG_trade + ">");
        }
        if (this.remarks != null && !this.remarks.equals("")) {
            xml.append("<RMK><![CDATA[" + this.remarks + "]]>" + "</" + TAG_remarks + ">");
        }
        xml.append("<SDE>" + this.side + "</" + TAG_side + ">" + "<" + TAG_timeStamp + ">" + dateFormat.format(this.timeStamp) + "</" + TAG_timeStamp + ">" + "</Class>");
        return xml.toString();
    }

    public String toString() {
        return "TradeConfirmation [trade=" + this.trade + ", remarks=" + this.remarks + ", side=" + this.side + "]";
    }
}

