/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import pk.com.softech.messages.Message;
import pk.com.softech.messages.TopSymbolData;

public class TopSymbolsResponse
extends Message {
    private static final long serialVersionUID = 100118L;
    TopSymbolData[] rows;
    int filled;
    public static final int GAINERS = 1;
    public static final int LOSERS = 2;
    public static final int VOLUME_LEADERS = 3;
    public static final int MARKET_MOVERS = 4;
    public static final int MARKET_SHAKERS = 5;
    public static final String INVALID_TYPE = "Invalid TopSymbols response type.";
    protected int responseType;
    public static final String TAG_filled = "FLD";
    public static final String TAG_requestType = "RTY";
    public static final String TAG_rows = "ROW";

    public TopSymbolsResponse() {
        super(422);
    }

    public TopSymbolsResponse(int responseType, int size) {
        super(422);
        this.rows = new TopSymbolData[size];
        this.filled = 0;
        this.setResponseType(responseType);
    }

    public TopSymbolsResponse(int responseType, TopSymbolData[] rows) {
        super(422);
        this.filled = 0;
        if (rows != null) {
            this.rows = new TopSymbolData[rows.length];
            System.arraycopy(rows, 0, this.rows, 0, rows.length);
            this.filled = rows.length;
        }
        this.setResponseType(responseType);
    }

    public void addTopSymbolData(TopSymbolData data) throws ArrayIndexOutOfBoundsException {
        this.rows[this.filled++] = data;
    }

    public void setResponseType(int responseType) {
        if (responseType != 1 && responseType != 2 && responseType != 3 && responseType != 4 && responseType != 5) {
            throw new IllegalArgumentException(INVALID_TYPE);
        }
        this.responseType = responseType;
    }

    public int getResponseType() {
        return this.responseType;
    }

    public TopSymbolData[] getrows() {
        return this.rows;
    }

    @Override
    public String toXML() {
        this.setCompress(true);
        StringBuffer xml = new StringBuffer("<Class name=\"TopSymbolsResponse\"><RTY>" + this.responseType + "</" + TAG_requestType + ">" + "<" + TAG_filled + ">" + this.filled + "</" + TAG_filled + ">");
        int i = 0;
        while (i < this.filled) {
            if (this.rows[i] != null) {
                xml.append("<ROW>" + this.rows[i].toXML() + "</" + TAG_rows + ">");
            }
            ++i;
        }
        xml.append("</Class>");
        return xml.toString();
    }
}

