/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import java.io.Serializable;
import java.text.SimpleDateFormat;

public class TopSymbolData
implements Serializable {
    private static final long serialVersionUID = 100116L;
    public static final int GAINERS = 1;
    public static final int LOSERS = 2;
    public static final int VOLUME_LEADERS = 3;
    public static final int MARKET_MOVERS = 4;
    public static final int MARKET_SHAKERS = 5;
    protected String symbol;
    protected float closePrice;
    protected float lastTradePrice;
    protected int totalTurnover;
    protected float change;
    protected float changePercentage;
    protected int dataType;
    public static final String TAG_symbol = "SYM";
    public static final String TAG_closePrice = "CLO";
    public static final String TAG_lastTradePrice = "LTP";
    public static final String TAG_totalTurnover = "TTO";
    public static final String TAG_change = "CHG";
    public static final String TAG_changePerc = "CPR";

    public TopSymbolData() {
    }

    public TopSymbolData(String symbol, float closePrice, float lastTradePrice, int totalTurnover, float change, float changePercentage) {
        this.setSymbol(symbol);
        this.setClosePrice(closePrice);
        this.setLastTradePrice(lastTradePrice);
        this.setTotalTurnover(totalTurnover);
        this.setChange(change);
        this.setChangePercentage(changePercentage);
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public void setClosePrice(float closePrice) {
        this.closePrice = closePrice;
    }

    public void setLastTradePrice(float lastTradePrice) {
        this.lastTradePrice = lastTradePrice;
    }

    public void setTotalTurnover(int totalTurnover) {
        this.totalTurnover = totalTurnover;
    }

    public void setChange(float change) {
        this.change = change;
    }

    public void setChangePercentage(float changePercentage) {
        this.changePercentage = changePercentage;
    }

    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public float getClosePrice() {
        return this.closePrice;
    }

    public float getLastTradePrice() {
        return this.lastTradePrice;
    }

    public int getTotalTurnover() {
        return this.totalTurnover;
    }

    public float getChange() {
        return this.change;
    }

    public float getChangePercentage() {
        return this.changePercentage;
    }

    public int getDataType() {
        return this.dataType;
    }

    public String toXML() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        dateFormat.setLenient(false);
        StringBuffer xml = new StringBuffer("<Class name=\"TopSymbolData\">");
        if (this.symbol != null && !this.symbol.equals("")) {
            xml.append("<SYM><![CDATA[" + this.symbol + "]]>" + "</" + TAG_symbol + ">");
        }
        xml.append("<CLO>" + this.closePrice + "</" + TAG_closePrice + ">" + "<" + TAG_lastTradePrice + ">" + this.lastTradePrice + "</" + TAG_lastTradePrice + ">" + "<" + TAG_totalTurnover + ">" + this.totalTurnover + "</" + TAG_totalTurnover + ">" + "<" + TAG_change + ">" + this.change + "</" + TAG_change + ">" + "<" + TAG_changePerc + ">" + this.changePercentage + "</" + TAG_changePerc + ">");
        xml.append("</Class>");
        return xml.toString();
    }
}

