/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import java.text.SimpleDateFormat;
import pk.com.softech.messages.Message;

public class TextMessage
extends Message {
    private static final long serialVersionUID = 100079L;
    protected String text;
    protected boolean pop;
    protected String[] userId;
    protected String userType;
    public static final String TAG_text = "TXT";
    public static final String TAG_pop = "POP";

    public TextMessage(String text) {
        this(text, false);
    }

    public TextMessage(String text, boolean popup) {
        this(text, popup, null, null);
    }

    public TextMessage(String text, boolean popup, String[] userId, String userType) {
        super(115);
        this.setText(text);
        this.setPop(popup);
        this.setUserId(userId);
        this.setUserType(userType);
    }

    public TextMessage() {
        super(115);
    }

    public void setText(String txt) {
        this.text = txt;
    }

    public String getText() {
        return this.text;
    }

    public void setPop(boolean popup) {
        this.pop = popup;
    }

    public boolean getPop() {
        return this.pop;
    }

    public void setUserId(String[] userid) {
        this.userId = userid;
    }

    public String[] getUserId() {
        return this.userId;
    }

    public String getUserType() {
        return this.userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public String getMessage() {
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
        return timeFormat.format(this.getTimeStamp()) + ": " + this.getText();
    }

    @Override
    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"TextMessage\">");
        if (this.text != null && !this.text.equals("")) {
            xml.append("<TXT><![CDATA[" + this.text + "]]>" + "</" + TAG_text + ">");
        }
        xml.append("<POP>" + this.pop + "</" + TAG_pop + ">" + "</Class>");
        return xml.toString();
    }
}

