/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import pk.com.softech.messages.Message;
import pk.com.softech.messages.SymbolData;

public class SymbolResponse
extends Message {
    private static final long serialVersionUID = 100078L;
    protected SymbolData[] rows;
    int filled = 0;
    public static final String TAG_filled = "FLD";
    public static final String TAG_rows = "ROW";

    public SymbolResponse(int size) {
        super(401);
        this.rows = new SymbolData[size];
        this.filled = 0;
    }

    public SymbolResponse(SymbolData[] symbols) {
        this(symbols.length);
        System.arraycopy(symbols, 0, this.rows, 0, symbols.length);
        this.filled = symbols.length;
    }

    public void addSymbol(SymbolData data) throws ArrayIndexOutOfBoundsException {
        this.rows[this.filled++] = data;
    }

    public SymbolData[] getSymbols() {
        return this.rows;
    }

    public String formatString() {
        String result = "SR|";
        int x = 0;
        while (x < this.rows.length) {
            result = String.valueOf(result) + this.rows[x].formatString(";") + "|";
            ++x;
        }
        return result;
    }

    @Override
    public String toXML() {
        this.setCompress(true);
        StringBuffer xml = new StringBuffer("<Class name=\"SymbolResponse\"><FLD>" + this.filled + "</" + TAG_filled + ">");
        int i = 0;
        while (i < this.filled) {
            if (this.rows[i] != null) {
                xml.append("<ROW>" + this.rows[i].toXML() + "</" + TAG_rows + ">");
            }
            ++i;
        }
        xml.append("</Class>");
        return xml.toString();
    }
}

