/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import pk.com.softech.messages.GraphData;
import pk.com.softech.messages.Message;

public class SymbolGraphResponse
extends Message {
    private static final long serialVersionUID = 100076L;
    GraphData[] rows;
    int filled;
    String viewTitle;
    public static final String TAG_filled = "FLD";
    public static final String TAG_rows = "ROW";

    public SymbolGraphResponse(int size) {
        super(408);
        this.rows = new GraphData[size];
        this.filled = 0;
    }

    public SymbolGraphResponse(GraphData[] rws, String viewTitle) {
        super(408);
        this.filled = 0;
        if (rws != null) {
            this.rows = new GraphData[rws.length];
            System.arraycopy(rws, 0, this.rows, 0, rws.length);
            this.filled = rws.length;
        }
        this.setViewTitle(viewTitle);
    }

    public void addSymbolGraph(GraphData data) throws ArrayIndexOutOfBoundsException {
        this.rows[this.filled++] = data;
    }

    public void setViewTitle(String viewTitle) {
        this.viewTitle = viewTitle;
    }

    public String getViewTitle() {
        return this.viewTitle;
    }

    public GraphData[] getrows() {
        return this.rows;
    }

    public String formatString() {
        return "";
    }

    @Override
    public String toXML() {
        this.setCompress(true);
        StringBuffer xml = new StringBuffer("<Class name=\"SymbolGraphResponse\"><FLD>" + this.filled + "</" + TAG_filled + ">");
        int i = 0;
        while (i < this.filled) {
            if (this.rows[i] != null) {
                xml.append("<ROW>" + this.rows[i].toXML() + "</" + TAG_rows + ">");
            }
            ++i;
        }
        xml.append("</Class>");
        return xml.toString();
    }
}

