/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import pk.com.softech.messages.Message;
import pk.com.softech.messages.SymbolFeedData;

public class SymbolFeedResponse
extends Message {
    private static final long serialVersionUID = 100074L;
    SymbolFeedData[] rows;
    int filled;
    String symbol;
    String market;
    public static final String TAG_filled = "FLD";
    public static final String TAG_symbol = "SYM";
    public static final String TAG_market = "MKT";
    public static final String TAG_rows = "ROW";

    public SymbolFeedResponse(String symbol, String market, int size) {
        super(409);
        this.rows = new SymbolFeedData[size];
        this.filled = 0;
        this.setSymbol(symbol);
        this.setMarket(market);
    }

    public SymbolFeedResponse(int size) {
        super(409);
        this.rows = new SymbolFeedData[size];
        this.filled = 0;
    }

    public SymbolFeedResponse(String symbol, String market, SymbolFeedData[] rows) {
        this(symbol, market, rows.length);
        System.arraycopy(rows, 0, this.rows, 0, rows.length);
        this.filled = rows.length;
    }

    public void addSymbolFeedData(SymbolFeedData data) throws ArrayIndexOutOfBoundsException {
        this.rows[this.filled++] = data;
    }

    public SymbolFeedData[] getrows() {
        return this.rows;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getMarket() {
        return this.market;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public void setMarket(String market) {
        this.market = market;
    }

    @Override
    public String toXML() {
        this.setCompress(true);
        StringBuffer xml = new StringBuffer("<Class name=\"SymbolFeedResponse\"><FLD>" + this.filled + "</" + TAG_filled + ">");
        if (this.symbol != null && !this.symbol.equals("")) {
            xml.append("<SYM><![CDATA[" + this.symbol + "]]>" + "</" + TAG_symbol + ">");
        }
        if (this.market != null && !this.market.equals("")) {
            xml.append("<MKT><![CDATA[" + this.market + "]]>" + "</" + TAG_market + ">");
        }
        int i = 0;
        while (i < this.filled) {
            if (this.rows[i] != null) {
                xml.append("<ROW>" + this.rows[i].toXML() + "</" + TAG_rows + ">");
            }
            ++i;
        }
        xml.append("</Class>");
        return xml.toString();
    }
}

