/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import pk.com.softech.messages.Feed;
import pk.com.softech.messages.MarketData;
import pk.com.softech.util.Utility;

public class SymbolFeedData
extends Feed {
    private static final long serialVersionUID = 100072L;
    int orderFeed = 0;
    int ghanaFeed = 0;
    protected String market;
    protected String symbol;
    protected float buyPrice;
    protected int buyVolume;
    protected float sellPrice;
    protected int sellVolume;
    protected float lastTradePrice;
    protected long lastTradeVolume;
    protected long totalTurnover;
    protected float lastDayClose;
    protected float high;
    protected float low;
    protected float average;
    protected float change;
    protected String spot;
    protected float intervalOpen;
    protected float intervalHigh;
    protected float intervalLow;
    protected long intervalTurnover;
    protected long intervalOpenTurnover;
    protected boolean clearIntervalOnUpdate;
    protected Date lastTradeTimeStamp;
    protected long totalTrades;
    protected Date spotFrom;
    protected Date spotTo;
    protected float open;
    protected String dir;
    protected long faceValue;
    protected double dividend;
    protected double bonusShare;
    protected double rightShare;
    protected double premium;
    public static final String TAG_identifier = "IDN";
    public static final String TAG_country = "CNT";
    public static final String TAG_exchange = "EXC";
    public static final String TAG_timeStamp = "TST";
    public static final String TAG_market = "MKT";
    public static final String TAG_symbol = "SYM";
    public static final String TAG_buyPrice = "BPR";
    public static final String TAG_buyVolume = "BVL";
    public static final String TAG_sellPrice = "SPR";
    public static final String TAG_sellVolume = "SVL";
    public static final String TAG_lastTradePrice = "LTP";
    public static final String TAG_lastTradeVolume = "LTV";
    public static final String TAG_lastTradeTime = "LTT";
    public static final String TAG_totalTurnover = "TTO";
    public static final String TAG_lastDayPrice = "LDP";
    public static final String TAG_high = "HGH";
    public static final String TAG_low = "LOW";
    public static final String TAG_average = "AVG";
    public static final String TAG_change = "CHG";
    public static final String TAG_spot = "SPT";
    public static final String TAG_spotFrom = "SPF";
    public static final String TAG_spotTo = "SPT";
    public static final String TAG_totalTrades = "TTR";
    public static final String TAG_open = "OPN";
    public static final String TAG_dir = "DIR";
    public static final String TAG_FaceValue = "TFV";
    public static final String TAG_dividend = "TDV";
    public static final String TAG_bonusShare = "TBS";
    public static final String TAG_rightShare = "TRS";
    public static final String TAG_premium = "TPR";

    public SymbolFeedData(int identifier, String country, String exchange, Date timeStamp, String market, String symbol, float buyPrice, int buyVolume, float sellPrice, int sellVolume, float lastTradePrice, long lastTradeVolume, long totalTurnover, float lastDayClose, float high, float low, float average, float change, Date lastTradeTimeStamp, long totalTrades) {
        this(identifier, country, exchange, timeStamp, market, symbol, buyPrice, buyVolume, sellPrice, sellVolume, lastTradePrice, lastTradeVolume, totalTurnover, lastDayClose, high, low, average, change, " ", null, null, lastTradeTimeStamp, totalTrades, 0.0f);
    }

    public SymbolFeedData(int identifier, String country, String exchange, Date timeStamp, String market, String symbol, float buyPrice, int buyVolume, float sellPrice, int sellVolume, float lastTradePrice, long lastTradeVolume, long totalTurnover, float lastDayClose, float high, float low, float average, float change) {
        this(identifier, country, exchange, timeStamp, market, symbol, buyPrice, buyVolume, sellPrice, sellVolume, lastTradePrice, lastTradeVolume, totalTurnover, lastDayClose, high, low, average, change, " ", null, null, null, 0L, 0.0f);
    }

    public SymbolFeedData(int identifier, String country, String exchange, Date timeStamp, String market, String symbol, float buyPrice, int buyVolume, float sellPrice, int sellVolume, float lastTradePrice, long lastTradeVolume, long totalTurnover, float lastDayClose, float high, float low, float average, float change, String spot, Date spotFrom, Date spotTo, Date lastTradeTimeStamp, long totalTrades, float open) {
        this.setIdentifier(identifier);
        this.setCountry(country);
        this.setExchange(exchange);
        this.setTimeStamp(timeStamp);
        this.setMarket(market);
        this.setSymbol(symbol);
        this.setBuyPrice(buyPrice);
        this.setBuyVolume(buyVolume);
        this.setSellPrice(sellPrice);
        this.setSellVolume(sellVolume);
        this.setLastTradePrice(lastTradePrice);
        this.setLastTradeVolume(lastTradeVolume);
        this.setTotalTurnover(totalTurnover);
        this.setLastDayClose(lastDayClose);
        this.setHigh(high);
        this.setLow(low);
        this.setAverage(average);
        this.setChange(change);
        this.setSpot(spot);
        this.setSpotFrom(spotFrom);
        this.setSpotTo(spotTo);
        this.setIntervalOpen(this.getLastTradePrice());
        this.setIntervalHigh(this.getLastTradePrice());
        this.setIntervalLow(this.getLastTradePrice());
        this.setIntervalTurnover(0);
        this.setIntervalOpenTurnover(totalTurnover);
        this.setLastTradeTimeStamp(lastTradeTimeStamp);
        this.setTotalTrades(totalTrades);
        this.setOpen(open);
        this.clearIntervalOnUpdate = false;
    }

    public SymbolFeedData(String feed) {
        try {
            StringTokenizer tokenizer = new StringTokenizer(feed, ",");
            this.setCountry(tokenizer.nextToken());
            this.setExchange(tokenizer.nextToken());
            this.setIdentifier(tokenizer.nextToken());
            this.setTimeStamp(this.formatDate(tokenizer.nextToken()));
            this.setSymbol(tokenizer.nextToken());
            this.setLastTradePrice(Utility.parseFloat(tokenizer.nextToken(), 0.0f));
            this.setLastTradeVolume(Utility.parseInt(tokenizer.nextToken(), 0));
            this.setMarket(tokenizer.nextToken());
            this.setBuyPrice(Utility.parseFloat(tokenizer.nextToken(), 0.0f));
            this.setSellPrice(Utility.parseFloat(tokenizer.nextToken(), 0.0f));
            this.setBuyVolume(Utility.parseInt(tokenizer.nextToken(), 0));
            this.setSellVolume(Utility.parseInt(tokenizer.nextToken(), 0));
            this.setLastDayClose(Utility.parseFloat(tokenizer.nextToken(), 0.0f));
            this.setTotalTurnover(Utility.parseInt(tokenizer.nextToken(), 0));
            this.setHigh(Utility.parseFloat(tokenizer.nextToken(), 0.0f));
            this.setLow(Utility.parseFloat(tokenizer.nextToken(), 0.0f));
            this.setAverage(Utility.parseFloat(tokenizer.nextToken(), 0.0f));
            tokenizer.nextToken();
            this.setChange(Utility.parseFloat(tokenizer.nextToken(), 0.0f));
            this.setSpot(tokenizer.nextToken());
            try {
                this.setIntervalOpen(Utility.parseFloat(tokenizer.nextToken(), 0.0f));
            }
            catch (Exception exception) {
                this.setIntervalOpen(0.0f);
            }
            try {
                this.setIntervalHigh(Utility.parseFloat(tokenizer.nextToken(), 0.0f));
            }
            catch (Exception exception) {
                this.setIntervalHigh(0.0f);
            }
            try {
                this.setIntervalLow(Utility.parseFloat(tokenizer.nextToken(), 0.0f));
            }
            catch (Exception exception) {
                this.setIntervalLow(0.0f);
            }
            try {
                this.setIntervalTurnover(Utility.parseInt(tokenizer.nextToken(), 0));
            }
            catch (Exception exception) {
                this.setIntervalTurnover(0);
            }
            try {
                this.setIntervalOpenTurnover(this.getTotalTurnover());
            }
            catch (Exception exception) {
                this.setIntervalOpenTurnover(0L);
            }
            this.setLastTradeTimeStamp(this.formatDate(tokenizer.nextToken()));
            this.setTotalTrades(Utility.parseInt(tokenizer.nextToken(), 0));
            this.setOpen(Utility.parseFloat(tokenizer.nextToken(), 0.0f));
            try {
                this.setDir(tokenizer.nextToken());
            }
            catch (Exception exception) {}
            this.setOrderFeed(Utility.parseInt(tokenizer.nextToken(), 0));
            this.setGhanaFeed(Utility.parseInt(tokenizer.nextToken(), 0));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public SymbolFeedData() {
    }

    public void update(SymbolFeedData newFeed, boolean intUpdate) {
        if (newFeed.getOrderFeed() == 0) {
            if (this.clearIntervalOnUpdate) {
                this.clearIntervalFeed();
            }
            this.setIdentifier(newFeed.getIdentifier());
            this.setCountry(newFeed.getCountry());
            this.setExchange(newFeed.getExchange());
            this.setTimeStamp(newFeed.getTimeStamp());
            this.setMarket(newFeed.getMarket());
            this.setSymbol(newFeed.getSymbol());
            this.setSpot(newFeed.getSpot());
            this.setDir(newFeed.getDir());
            if (newFeed.getGhanaFeed() == 0) {
                if (newFeed.getBuyPrice() != -1.0f) {
                    this.setBuyPrice(newFeed.getBuyPrice());
                }
                if (newFeed.getSellPrice() != -1.0f) {
                    this.setSellPrice(newFeed.getSellPrice());
                }
                if (newFeed.getBuyVolume() != -1) {
                    this.setBuyVolume(newFeed.getBuyVolume());
                }
                if (newFeed.getSellVolume() != -1) {
                    this.setSellVolume(newFeed.getSellVolume());
                }
            } else if (newFeed.getLastTradePrice() > 0.0f && newFeed.getLastTradePrice() == this.getBuyPrice() && this.getBuyPrice() == this.getSellPrice()) {
                if (newFeed.getBuyPrice() != -1.0f) {
                    this.setBuyPrice(newFeed.getBuyPrice());
                }
                if (newFeed.getSellPrice() != -1.0f) {
                    this.setSellPrice(newFeed.getSellPrice());
                }
                if (newFeed.getBuyVolume() != -1) {
                    this.setBuyVolume(newFeed.getBuyVolume());
                }
                if (newFeed.getSellVolume() != -1) {
                    this.setSellVolume(newFeed.getSellVolume());
                }
            }
            if (newFeed.getLastTradePrice() > 0.0f) {
                this.setLastTradePrice(newFeed.getLastTradePrice());
            }
            if (newFeed.getLastTradeVolume() > 0L) {
                this.setLastTradeVolume(newFeed.getLastTradeVolume());
            }
            if (newFeed.getLastTradeTimeStamp() != null) {
                this.setLastTradeTimeStamp(newFeed.getLastTradeTimeStamp());
            }
            if (newFeed.getTotalTurnover() > 0L) {
                this.setTotalTurnover(newFeed.getTotalTurnover());
            }
            if (newFeed.getOpen() > 0.0f) {
                this.setOpen(newFeed.getOpen());
            }
            if (newFeed.getLastDayClose() > 0.0f) {
                this.setLastDayClose(newFeed.getLastDayClose());
            }
            if (newFeed.getHigh() > 0.0f) {
                this.setHigh(newFeed.getHigh());
            }
            if (newFeed.getLow() > 0.0f) {
                this.setLow(newFeed.getLow());
            }
            if (newFeed.getAverage() > 0.0f) {
                this.setAverage(newFeed.getAverage());
            }
            if (newFeed.getChange() != -999999.0f) {
                this.setChange(newFeed.getChange());
            }
            if (newFeed.getTotalTrades() > 0L) {
                this.setTotalTrades(newFeed.getTotalTrades());
            }
            if (newFeed.getChange() == -999999.0f) {
                this.setChange(newFeed.getLastTradePrice() - this.getLastDayClose());
            }
            if (this.intervalOpen == 0.0f) {
                this.intervalOpen = newFeed.getLastTradePrice();
            }
            if (this.intervalHigh == 0.0f) {
                this.intervalHigh = newFeed.getLastTradePrice();
            } else if (this.intervalHigh < newFeed.getLastTradePrice()) {
                this.intervalHigh = newFeed.getLastTradePrice();
            }
            if (this.intervalLow == 0.0f) {
                this.intervalLow = newFeed.getLastTradePrice();
            } else if (this.intervalLow > newFeed.getLastTradePrice()) {
                this.intervalLow = newFeed.getLastTradePrice();
            }
            if (this.intervalOpenTurnover == 0L) {
                this.intervalOpenTurnover = newFeed.getTotalTurnover();
            }
            this.intervalTurnover = newFeed.getTotalTurnover() - this.intervalOpenTurnover;
        } else {
            if (newFeed.getBuyPrice() != -1.0f) {
                this.setBuyPrice(newFeed.getBuyPrice());
            }
            if (newFeed.getSellPrice() != -1.0f) {
                this.setSellPrice(newFeed.getSellPrice());
            }
            if (newFeed.getBuyVolume() != -1) {
                this.setBuyVolume(newFeed.getBuyVolume());
            }
            if (newFeed.getSellVolume() != -1) {
                this.setSellVolume(newFeed.getSellVolume());
            }
        }
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public void setMarket(String market) {
        if (!MarketData.verifyName(market)) {
            throw new IllegalArgumentException("Unidentifiable market name: ");
        }
        this.market = market;
    }

    public void setBuyPrice(float buyPrice) {
        this.buyPrice = buyPrice;
    }

    public void setBuyVolume(int buyVolume) {
        this.buyVolume = buyVolume;
    }

    public void setSellVolume(int sellVolume) {
        this.sellVolume = sellVolume;
    }

    public void setSellPrice(float sellPrice) {
        this.sellPrice = sellPrice;
    }

    public void setLastTradePrice(float lastTradePrice) {
        this.lastTradePrice = lastTradePrice;
    }

    public void setLastTradeVolume(long lastTradeVolume) {
        this.lastTradeVolume = lastTradeVolume;
    }

    public void setTotalTurnover(long turnover) {
        this.totalTurnover = turnover;
    }

    public void setLastDayClose(float lastDayClose) {
        this.lastDayClose = lastDayClose;
    }

    public void setHigh(float high) {
        this.high = high;
    }

    public void setLow(float low) {
        this.low = low;
    }

    public void setAverage(float average) {
        this.average = average;
    }

    public void setChange(float change) {
        this.change = change;
    }

    public void setSpot(String spot) {
        this.spot = spot;
    }

    public void setIntervalOpen(float intervalOpen) {
        this.intervalOpen = intervalOpen;
    }

    public void setIntervalHigh(float intervalHigh) {
        this.intervalHigh = intervalHigh;
    }

    public void setIntervalLow(float intervalLow) {
        this.intervalLow = intervalLow;
    }

    public void setIntervalTurnover(int intervalTurnover) {
        this.intervalTurnover = intervalTurnover;
    }

    public void setIntervalOpenTurnover(long intervalOpenTurnover) {
        this.intervalOpenTurnover = intervalOpenTurnover;
    }

    public void setLastTradeTimeStamp(Date tradetimeStamp) {
        this.lastTradeTimeStamp = tradetimeStamp;
    }

    public void setTotalTrades(long totalTrades) {
        this.totalTrades = totalTrades;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getMarket() {
        return this.market;
    }

    public int getBuyVolume() {
        return this.buyVolume;
    }

    public float getBuyPrice() {
        return this.buyPrice;
    }

    public int getSellVolume() {
        return this.sellVolume;
    }

    public float getSellPrice() {
        return this.sellPrice;
    }

    public float getLastTradePrice() {
        return this.lastTradePrice;
    }

    public long getLastTradeVolume() {
        return this.lastTradeVolume;
    }

    public long getTotalTurnover() {
        return this.totalTurnover;
    }

    public float getLastDayClose() {
        return this.lastDayClose;
    }

    public float getHigh() {
        return this.high;
    }

    public float getLow() {
        return this.low;
    }

    public float getAverage() {
        return this.average;
    }

    public float getChange() {
        return this.change;
    }

    public String getSpot() {
        return this.spot;
    }

    public float getIntervalOpen() {
        return this.intervalOpen;
    }

    public float getIntervalHigh() {
        return this.intervalHigh;
    }

    public float getIntervalLow() {
        return this.intervalLow;
    }

    public long getIntervalTurnover() {
        return this.intervalTurnover;
    }

    public long getIntervalOpenTurnover() {
        return this.intervalOpenTurnover;
    }

    public Date getLastTradeTimeStamp() {
        return this.lastTradeTimeStamp;
    }

    public long getTotalTrades() {
        return this.totalTrades;
    }

    public void setSpotFrom(Date spotFrom) {
        this.spotFrom = spotFrom;
    }

    public Date getSpotFrom() {
        return this.spotFrom;
    }

    public void setSpotTo(Date spotTo) {
        this.spotTo = spotTo;
    }

    public Date getSpotTo() {
        return this.spotTo;
    }

    public float getOpen() {
        return this.open;
    }

    public void setOpen(float open) {
        this.open = open;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public void clearIntervalFeedOnUpdate() {
        this.clearIntervalOnUpdate = true;
    }

    public void setFaceValue(long faceValue) {
        this.faceValue = faceValue;
    }

    public long getFaceValue() {
        return this.faceValue;
    }

    public void setDividend(double dividend) {
        this.dividend = dividend;
    }

    public double getDividend() {
        return this.dividend;
    }

    public void setBonusShare(double bonusShare) {
        this.bonusShare = bonusShare;
    }

    public double getBonusShare() {
        return this.bonusShare;
    }

    public void setRightShare(double rightShare) {
        this.rightShare = rightShare;
    }

    public double getRightShare() {
        return this.rightShare;
    }

    public void setPremium(double premium) {
        this.premium = premium;
    }

    public double getPremium() {
        return this.premium;
    }

    public void clearIntervalFeed() {
        this.setIntervalOpen(0.0f);
        this.setIntervalHigh(0.0f);
        this.setIntervalLow(0.0f);
        this.setIntervalTurnover(0);
        this.setIntervalOpenTurnover(this.totalTurnover);
        this.clearIntervalOnUpdate = false;
    }

    public String formatString() {
        String messType = null;
        messType = this.identifier == 2 ? "LLT" : "LLM";
        return String.valueOf(this.country) + "," + this.exchange + "," + messType + "," + this.formatDate(this.timeStamp) + "," + this.symbol + "," + this.formatFloat(this.lastTradePrice) + "," + this.formatLong(this.lastTradeVolume) + "," + this.market + "," + this.formatFloat(this.buyPrice) + "," + this.formatFloat(this.sellPrice) + "," + this.formatInt(this.buyVolume) + "," + this.formatInt(this.sellVolume) + "," + this.formatFloat(this.lastDayClose) + "," + this.formatLong(this.totalTurnover) + "," + this.formatFloat(this.high) + "," + this.formatFloat(this.low) + "," + this.formatFloat(this.average) + "," + 0 + "," + this.change + "," + this.spot + "," + this.formatFloat(this.intervalOpen) + "," + this.formatFloat(this.intervalHigh) + "," + this.formatFloat(this.intervalLow) + "," + this.formatLong(this.intervalTurnover) + "," + this.formatDate(this.lastTradeTimeStamp) + "," + this.formatLong(this.totalTrades) + "," + this.formatFloat(this.open) + "," + this.dir + "," + this.getOrderFeed() + "," + this.getGhanaFeed() + "," + "END_MESSEGE" + ",";
    }

    public String formatFloat(float number) {
        if (number == 0.0f) {
            return " ";
        }
        return "" + number;
    }

    public String formatInt(int number) {
        if (number == 0) {
            return " ";
        }
        return "" + number;
    }

    public String formatLong(long number) {
        if (number == 0L) {
            return " ";
        }
        return "" + number;
    }

    public int getOrderFeed() {
        return this.orderFeed;
    }

    public void setOrderFeed(int orderFeed) {
        this.orderFeed = orderFeed;
    }

    public void setGhanaFeed(int ghanaFeed) {
        this.ghanaFeed = ghanaFeed;
    }

    public int getGhanaFeed() {
        return this.ghanaFeed;
    }

    public String formatDate(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        df.setLenient(false);
        if (date == null) {
            return " ";
        }
        return df.format(date);
    }

    public Date formatDate(String date) {
        SimpleDateFormat df;
        block3: {
            try {
                df = new SimpleDateFormat("yyyyMMddHHmmss");
                df.setLenient(false);
                if (!date.equals(" ") && !date.equals("")) break block3;
                return null;
            }
            catch (ParseException pe) {
                System.out.println("Unable to parse date:'" + date + "' " + pe.getMessage());
                return null;
            }
        }
        return df.parse(date);
    }

    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"SymbolFeedData\"><IDN>" + this.identifier + "</" + TAG_identifier + ">");
        if (this.country != null && !this.country.equals("")) {
            xml.append("<CNT><![CDATA[" + this.country + "]]>" + "</" + TAG_country + ">");
        }
        if (this.exchange != null && !this.exchange.equals("")) {
            xml.append("<EXC><![CDATA[" + this.exchange + "]]>" + "</" + TAG_exchange + ">");
        }
        xml.append("<TST>" + this.formatDate(this.timeStamp) + "</" + TAG_timeStamp + ">");
        if (this.market != null && !this.market.equals("")) {
            xml.append("<MKT><![CDATA[" + this.market + "]]>" + "</" + TAG_market + ">");
        }
        if (this.symbol != null && !this.symbol.equals("")) {
            xml.append("<SYM><![CDATA[" + this.symbol + "]]>" + "</" + TAG_symbol + ">");
        }
        xml.append("<BPR>" + this.buyPrice + "</" + TAG_buyPrice + ">" + "<" + TAG_buyVolume + ">" + this.buyVolume + "</" + TAG_buyVolume + ">" + "<" + TAG_sellPrice + ">" + this.sellPrice + "</" + TAG_sellPrice + ">" + "<" + TAG_sellVolume + ">" + this.sellVolume + "</" + TAG_sellVolume + ">" + "<" + TAG_lastTradePrice + ">" + this.lastTradePrice + "</" + TAG_lastTradePrice + ">" + "<" + TAG_lastTradeVolume + ">" + this.lastTradeVolume + "</" + TAG_lastTradeVolume + ">" + "<" + TAG_lastTradeTime + ">" + this.formatDate(this.lastTradeTimeStamp) + "</" + TAG_lastTradeTime + ">" + "<" + TAG_totalTurnover + ">" + this.totalTurnover + "</" + TAG_totalTurnover + ">" + "<" + TAG_lastDayPrice + ">" + this.lastDayClose + "</" + TAG_lastDayPrice + ">" + "<" + TAG_high + ">" + this.high + "</" + TAG_high + ">" + "<" + TAG_low + ">" + this.low + "</" + TAG_low + ">" + "<" + TAG_average + ">" + this.average + "</" + TAG_average + ">" + "<" + TAG_change + ">" + this.change + "</" + TAG_change + ">");
        if (this.spot != null && !this.spot.equals("")) {
            xml.append("<SPT><![CDATA[" + this.spot + "]]>" + "</" + "SPT" + ">");
        }
        if (this.spotFrom != null) {
            xml.append("<SPF><![CDATA[" + this.spotFrom + "]]>" + "</" + TAG_spotFrom + ">");
        }
        if (this.spotTo != null) {
            xml.append("<SPT><![CDATA[" + this.spotTo + "]]>" + "</" + "SPT" + ">");
        }
        xml.append("<TTR>" + this.totalTrades + "</" + TAG_totalTrades + ">");
        xml.append("<OPN>" + this.open + "</" + TAG_open + ">");
        xml.append("<DIR>" + this.dir + "</" + TAG_dir + ">");
        xml.append("<TFV><![CDATA[" + this.faceValue + "]]>" + "</" + TAG_FaceValue + ">");
        xml.append("<TDV><![CDATA[" + this.dividend + "]]>" + "</" + TAG_dividend + ">");
        xml.append("<TBS><![CDATA[" + this.bonusShare + "]]>" + "</" + TAG_bonusShare + ">");
        xml.append("<TRS><![CDATA[" + this.rightShare + "]]>" + "</" + TAG_rightShare + ">");
        xml.append("<TPR><![CDATA[" + this.premium + "]]>" + "</" + TAG_premium + ">");
        xml.append("</Class>");
        return xml.toString();
    }
}

