/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import java.io.Serializable;

public class SymbolData
implements Serializable,
Comparable {
    private static final long serialVersionUID = 100071L;
    protected String symbol;
    protected String market;
    protected String exchange;
    protected String name;
    protected float closingPrice;
    protected float upperLimit;
    protected float lowerLimit;
    protected int maxOrderVolume;
    protected float maxOrderValue;
    protected int lotSize;
    protected String currency;
    protected String sector;
    public static final String TAG_exchange = "EXC";
    public static final String TAG_symbol = "SYM";
    public static final String TAG_market = "MKT";
    public static final String TAG_name = "NAM";
    public static final String TAG_closingPrice = "CPR";
    public static final String TAG_upperLimit = "ULM";
    public static final String TAG_lowerLimit = "LLM";
    public static final String TAG_maxOrderVolume = "MOV";
    public static final String TAG_maxOrderValue = "MOL";
    public static final String TAG_lotSize = "LSZ";
    public static final String TAG_currency = "CUR";
    public static final String TAG_sector = "SCT";

    public SymbolData(String symbol, String name, float closingPrice, float upperLimit, float lowerLimit, int maxOrderVolume, float maxOrderValue, int lotSize, String market, String exchange, String currency, String sector) {
        this.setSymbol(symbol);
        this.setName(name);
        this.setMarket(market);
        this.setExchange(exchange);
        this.setClosingPrice(closingPrice);
        this.setUpperLimit(upperLimit);
        this.setLowerLimit(lowerLimit);
        this.setMaxOrderVolume(maxOrderVolume);
        this.setMaxOrderValue(maxOrderValue);
        this.setLotSize(lotSize);
        this.setCurrency(currency);
        this.setSector(sector);
    }

    public SymbolData() {
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getMarket() {
        return this.market;
    }

    public String getExchange() {
        return this.exchange;
    }

    public String getName() {
        return this.name;
    }

    public float getClosingPrice() {
        return this.closingPrice;
    }

    public float getUpperLimit() {
        return this.upperLimit;
    }

    public float getLowerLimit() {
        return this.lowerLimit;
    }

    public int getMaxOrderVolume() {
        return this.maxOrderVolume;
    }

    public float getMaxOrderValue() {
        return this.maxOrderValue;
    }

    public int getLotSize() {
        return this.lotSize;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public void setMarket(String market) {
        this.market = market;
    }

    public void setExchange(String exchange) {
        this.exchange = exchange;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setClosingPrice(float closingPrice) {
        this.closingPrice = closingPrice;
    }

    public void setUpperLimit(float upperLimit) {
        this.upperLimit = upperLimit;
    }

    public void setLowerLimit(float lowerLimit) {
        this.lowerLimit = lowerLimit;
    }

    public void setMaxOrderVolume(int volume) {
        this.maxOrderVolume = volume;
    }

    public void setMaxOrderValue(float value) {
        this.maxOrderValue = value;
    }

    public void setLotSize(int value) {
        this.lotSize = value;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getSector() {
        return this.sector;
    }

    public void setSector(String sector) {
        this.sector = sector;
    }

    public String formatString(String delimeter) {
        return String.valueOf(this.getSymbol()) + delimeter + this.getName() + delimeter + this.getClosingPrice() + delimeter + this.getUpperLimit() + delimeter + this.getLowerLimit() + delimeter + this.getMaxOrderVolume() + delimeter + this.getMaxOrderValue() + delimeter + this.getLotSize() + delimeter + this.getMarket() + delimeter + this.getCurrency() + delimeter + this.getSector() + delimeter;
    }

    public int compareTo(Object data) {
        return this.symbol.compareTo(((SymbolData)data).getSymbol());
    }

    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"SymbolData\">");
        if (this.symbol != null && !this.symbol.equals("")) {
            xml.append("<SYM><![CDATA[" + this.symbol + "]]>" + "</" + TAG_symbol + ">");
        }
        if (this.name != null && !this.name.equals("")) {
            xml.append("<NAM><![CDATA[" + this.name + "]]>" + "</" + TAG_name + ">");
        }
        xml.append("<CPR>" + this.closingPrice + "</" + TAG_closingPrice + ">" + "<" + TAG_upperLimit + ">" + this.upperLimit + "</" + TAG_upperLimit + ">" + "<" + TAG_lowerLimit + ">" + this.lowerLimit + "</" + TAG_lowerLimit + ">" + "<" + TAG_maxOrderVolume + ">" + this.maxOrderVolume + "</" + TAG_maxOrderVolume + ">" + "<" + TAG_maxOrderValue + ">" + this.maxOrderValue + "</" + TAG_maxOrderValue + ">" + "<" + TAG_lotSize + ">" + this.lotSize + "</" + TAG_lotSize + ">" + "<" + TAG_market + ">" + this.market + "</" + TAG_market + ">" + "<" + TAG_currency + ">" + this.currency + "</" + TAG_currency + ">" + "<" + TAG_sector + ">" + this.sector + "</" + TAG_sector + ">" + "</Class>");
        return xml.toString();
    }
}

