/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import pk.com.softech.messages.ChartData;
import pk.com.softech.messages.Message;

public class SymbolChartResponse
extends Message {
    private static final long serialVersionUID = 100076L;
    public static final int HISTORY = 0;
    public static final int INTRADAY = 1;
    String symbol;
    String market;
    ChartData[] rows;
    int filled;
    int chartType;
    public static final String TAG_filled = "FLD";
    public static final String TAG_rows = "ROW";

    public SymbolChartResponse(String symbol, String market, int size, int chartType) {
        super(425);
        this.rows = new ChartData[size];
        this.filled = 0;
        this.setSymbol(symbol);
        this.setMarket(market);
        this.setChartType(chartType);
    }

    public SymbolChartResponse(String symbol, String market, ChartData[] rws, int chartType) {
        super(408);
        this.filled = 0;
        if (rws != null) {
            this.rows = new ChartData[rws.length];
            System.arraycopy(rws, 0, this.rows, 0, rws.length);
            this.filled = rws.length;
        }
        this.setSymbol(symbol);
        this.setMarket(market);
        this.setChartType(chartType);
    }

    public void addSymbolGraph(ChartData data) throws ArrayIndexOutOfBoundsException {
        this.rows[this.filled++] = data;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setMarket(String market) {
        this.market = market;
    }

    public String getMarket() {
        return this.market;
    }

    public ChartData[] getrows() {
        return this.rows;
    }

    public int getChartType() {
        return this.chartType;
    }

    public void setChartType(int chartType) {
        this.chartType = chartType;
    }

    public String formatString() {
        return "";
    }

    @Override
    public String toXML() {
        this.setCompress(true);
        StringBuffer xml = new StringBuffer("<Class name=\"SymbolChartResponse\"><FLD>" + this.filled + "</" + TAG_filled + ">");
        int i = 0;
        while (i < this.filled) {
            if (this.rows[i] != null) {
                xml.append("<ROW>" + this.rows[i].toXML() + "</" + TAG_rows + ">");
            }
            ++i;
        }
        xml.append("</Class>");
        return xml.toString();
    }
}

