/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import pk.com.softech.messages.Message;
import pk.com.softech.messages.SubscriptionRequest;

public class SubscriptionResponse
extends Message {
    protected String userId;
    protected String symbol;
    protected String requestType;
    protected String response;
    protected float tradePrice;
    protected float buyPrice;
    protected float sellPrice;
    protected float change;
    protected int turnover;
    protected String exchange;
    protected String indicator;

    public SubscriptionResponse() {
        super(0);
    }

    public SubscriptionResponse(String userId, String symbol, String requestType, String response, float tradePrice, float buyPrice, float sellPrice, float change, int turnover, String exchange) {
        super(0);
        this.setUserId(userId);
        this.setSymbol(symbol);
        this.setRequestType(requestType);
        this.setResponse(response);
        this.setTradePrice(tradePrice);
        this.setBuyPrice(buyPrice);
        this.setSellPrice(sellPrice);
        this.setChange(change);
        this.setTurnover(turnover);
        this.setExchange(exchange);
    }

    public void setRequestType(String requestType) throws IllegalArgumentException {
        if (!requestType.equals(SubscriptionRequest.ADD) && !requestType.equals(SubscriptionRequest.REMOVE)) {
            throw new IllegalArgumentException();
        }
        this.requestType = requestType;
    }

    public void setResponse(String response) throws IllegalArgumentException {
        if (!response.equals(SubscriptionRequest.ACCEPT) && !response.equals(SubscriptionRequest.REJECT)) {
            throw new IllegalArgumentException();
        }
        this.response = response;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public String getResponse() {
        return this.response;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getUserId() {
        return this.userId;
    }

    public float getTradePrice() {
        return this.tradePrice;
    }

    public float getSellPrice() {
        return this.sellPrice;
    }

    public float getBuyPrice() {
        return this.buyPrice;
    }

    public float getChange() {
        return this.change;
    }

    public int getTurnover() {
        return this.turnover;
    }

    public String getExchange() {
        return this.exchange;
    }

    public String getIndicator() {
        return this.indicator;
    }

    public void setTradePrice(float tradePrice) {
        this.tradePrice = tradePrice;
    }

    public void setBuyPrice(float buyPrice) {
        this.buyPrice = buyPrice;
    }

    public void setSellPrice(float sellPrice) {
        this.sellPrice = sellPrice;
    }

    public void setChange(float change) {
        this.change = change;
        this.setIndicator();
    }

    private void setIndicator() {
        this.indicator = (double)this.change == 0.0 ? "=" : ((double)this.change > 0.0 ? "+" : "-");
    }

    public void setTurnover(int turnover) {
        this.turnover = turnover;
    }

    public void setExchange(String exchange) {
        this.exchange = exchange;
    }
}

