/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import java.io.Serializable;
import java.util.Date;

public class SpotSymbolData
implements Serializable {
    private static final long serialVersionUID = 100184L;
    protected String symbolName;
    protected Date spotDate;
    protected Date spotTillDate;
    protected long faceValue;
    protected double dividend;
    protected double bonusShare;
    protected double rightShare;
    protected double premium;
    public static final String TAG_symbolName = "SMN";
    public static final String TAG_spotDate = "SPD";
    public static final String TAG_spotTillDate = "STD";
    public static final String TAG_FaceValue = "TFV";
    public static final String TAG_dividend = "TDV";
    public static final String TAG_bonusShare = "TBS";
    public static final String TAG_rightShare = "TRS";
    public static final String TAG_premium = "TPR";

    public SpotSymbolData(String symbolName, Date spotDate, Date spotTillDate, long faceValue, double dividend, double bonusShare, double rightShare, double premium) {
        this.setSymbolName(symbolName);
        this.setSpotDate(spotDate);
        this.setSpotTillDate(spotTillDate);
        this.setFaceValue(faceValue);
        this.setDividend(dividend);
        this.setBonusShare(bonusShare);
        this.setRightShare(rightShare);
        this.setPremium(premium);
    }

    public SpotSymbolData() {
    }

    public String getSymbolName() {
        return this.symbolName;
    }

    public Date getSpotTillDate() {
        return this.spotTillDate;
    }

    public Date getSpotDate() {
        return this.spotDate;
    }

    public void setSymbolName(String symbolName) {
        this.symbolName = symbolName;
    }

    public void setSpotTillDate(Date spotTillDate) {
        this.spotTillDate = spotTillDate;
    }

    public void setSpotDate(Date spotDate) {
        this.spotDate = spotDate;
    }

    public void setFaceValue(long faceValue) {
        this.faceValue = faceValue;
    }

    public long getFaceValue() {
        return this.faceValue;
    }

    public void setDividend(double dividend) {
        this.dividend = dividend;
    }

    public double getDividend() {
        return this.dividend;
    }

    public void setBonusShare(double bonusShare) {
        this.bonusShare = bonusShare;
    }

    public double getBonusShare() {
        return this.bonusShare;
    }

    public void setRightShare(double rightShare) {
        this.rightShare = rightShare;
    }

    public double getRightShare() {
        return this.rightShare;
    }

    public void setPremium(double premium) {
        this.premium = premium;
    }

    public double getPremium() {
        return this.premium;
    }

    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"SpotSymbolData\">");
        if (this.symbolName != null && !this.symbolName.equals("")) {
            xml.append("<SMN><![CDATA[" + this.symbolName + "]]>" + "</" + TAG_symbolName + ">");
        }
        xml.append("<SPD><![CDATA[" + this.spotDate + "]]>" + "</" + TAG_spotDate + ">");
        xml.append("<STD><![CDATA[" + this.spotTillDate + "]]>" + "</" + TAG_spotTillDate + ">");
        xml.append("<TFV><![CDATA[" + this.faceValue + "]]>" + "</" + TAG_FaceValue + ">");
        xml.append("<TDV><![CDATA[" + this.dividend + "]]>" + "</" + TAG_dividend + ">");
        xml.append("<TBS><![CDATA[" + this.bonusShare + "]]>" + "</" + TAG_bonusShare + ">");
        xml.append("<TRS><![CDATA[" + this.rightShare + "]]>" + "</" + TAG_rightShare + ">");
        xml.append("<TPR><![CDATA[" + this.premium + "]]>" + "</" + TAG_premium + ">");
        xml.append("</Class>");
        return xml.toString();
    }
}

