/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import java.util.Hashtable;
import pk.com.softech.messages.Message;

public class ReportResponse
extends Message {
    private static final long serialVersionUID = 100068L;
    public static final int PERIODIC_TRADE_DETAIL = 1;
    public static final int PERIODIC_TRADE_SUMMARY = 2;
    public static final int CASH_BOOK_DETAIL_WRT_TRADES = 3;
    public static final int CLIENT_ACCOUNT_LEDGER = 4;
    public static final int NET_SHARE_CUSTODY = 5;
    public static final int GROUP_COT_ORDERS = 6;
    public static final int GROUP_COT_TRADES = 7;
    public static final int PAYMENT_REQUEST = 8;
    public static final int CLIENT_MARGIN_REQUEST = 9;
    public static final int OUTSTANDING_ORDERS = 10;
    public static final int TRADE_CONFIRMATION = 11;
    public static final int INTEGRATED_LEDGER = 12;
    public static final int PORTFOLIO_SUMMARY = 13;
    public static final int CLIENT_FLOORS = 14;
    public static final int PROFIT_LOSS_REPORT = 15;
    public static final int MARGIN_DETAIL_REPORT = 16;
    public static final int DIVIDEND_BONUS_HISTORY = 17;
    public static final int PAYMENT_HISTORY = 18;
    public static final int CGT_HISTORY = 19;
    protected int reportNo;
    protected String HTML;
    protected Hashtable chartValues;
    public static final String TAG_reportNo = "RNO";
    public static final String TAG_HTML = "HTM";

    public ReportResponse(int reportType, String html) {
        super(0);
        this.setReportType(reportType);
        this.setHTML(html);
    }

    public ReportResponse(int reportType, Hashtable hashData, int i) {
        super(0);
        this.setReportType(reportType);
        String html = (String)hashData.get("html");
        this.setHTML(html);
        Hashtable chartValues = (Hashtable)hashData.get("chart");
        this.setChartValues(chartValues);
    }

    public ReportResponse() {
        super(0);
    }

    public void setChartValues(Hashtable chartValues) {
        this.chartValues = chartValues;
    }

    public Hashtable getChartValues() {
        return this.chartValues;
    }

    public void setReportType(int reportType) {
        switch (reportType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                this.reportNo = reportType;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid report response type.");
            }
        }
    }

    public int getReportType() {
        return this.reportNo;
    }

    public void setHTML(String html) {
        this.HTML = html;
    }

    public String getHTML() {
        return this.HTML;
    }

    public String formatString() {
        return "";
    }

    @Override
    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"ReportResponse\"><RNO>" + this.reportNo + "</" + TAG_reportNo + ">");
        if (this.HTML != null && !this.HTML.equals("")) {
            xml.append("<HTM><![CDATA[" + this.HTML + "]]>" + "</" + TAG_HTML + ">");
        }
        xml.append("</Class>");
        return xml.toString();
    }
}

