/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import java.text.SimpleDateFormat;
import java.util.Date;
import pk.com.softech.messages.Message;

public class ReportRequest
extends Message {
    private static final long serialVersionUID = 100067L;
    public static final int PERIODIC_TRADE_DETAIL = 1;
    public static final int PERIODIC_TRADE_SUMMARY = 2;
    public static final int CASH_BOOK_DETAIL_WRT_TRADES = 3;
    public static final int CLIENT_ACCOUNT_LEDGER = 4;
    public static final int NET_SHARE_CUSTODY = 5;
    public static final int GROUP_COT_ORDERS = 6;
    public static final int GROUP_COT_TRADES = 7;
    public static final int PAYMENT_REQUEST = 8;
    public static final int CLIENT_MARGIN_REQUEST = 9;
    public static final int OUTSTANDING_ORDERS_REQUEST = 10;
    public static final int TRADE_CONFIRMATION = 11;
    public static final int INTEGRATED_LEDGER = 12;
    public static final int PORTFOLIO_SUMMARY = 13;
    public static final int CLIENT_FLOORS = 14;
    public static final int PROFIT_LOSS_REPORT = 15;
    public static final int MARGIN_DETAIL_REPORT = 16;
    public static final int DIVIDEND_BONUS_HISTORY = 17;
    public static final int PAYMENT_HISTORY = 18;
    public static final int CGT_HISTORY = 19;
    protected int reportNo;
    protected Date startDate;
    protected Date endDate;
    protected String security;
    protected String clearingType;
    protected String client;
    protected String subCode;
    private String traderCode;
    protected String branchCode;
    protected String clientGroup;
    public static final String TAG_reportNo = "RNO";
    public static final String TAG_startDate = "SDT";
    public static final String TAG_endDate = "EDT";
    public static final String TAG_security = "SEC";
    public static final String TAG_clearingType = "CTP";
    public static final String TAG_client = "CLI";

    public ReportRequest(int reportType, String client, Date fromDate, Date toDate) {
        super(0);
        this.setReportType(reportType);
        this.setFromDate(fromDate);
        this.setToDate(toDate);
        this.setClient(client);
    }

    public ReportRequest() {
        super(0);
    }

    public ReportRequest(int reportType, String client, Date fromDate, Date toDate, String symbol, String clearing) {
        this(reportType, client, fromDate, toDate);
        this.setSymbol(symbol);
        this.setClearing(clearing);
    }

    public ReportRequest(int reportType, String client) {
        super(0);
        this.setReportType(reportType);
        this.setClient(client);
    }

    public ReportRequest(int reportType, String client, String subCode) {
        super(0);
        this.setReportType(reportType);
        this.setClient(client);
        this.setSubCode(subCode);
    }

    public int getReportType() {
        return this.reportNo;
    }

    public Date getFromDate() {
        return this.startDate;
    }

    public Date getToDate() {
        return this.endDate;
    }

    public String getSymbol() {
        return this.security;
    }

    public String getClearing() {
        return this.clearingType;
    }

    public String getClient() {
        return this.client;
    }

    public String getSubCode() {
        return this.subCode;
    }

    public void setReportType(int reportType) {
        switch (reportType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                this.reportNo = reportType;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid report request type.");
            }
        }
    }

    public void setFromDate(Date fromDate) {
        this.startDate = new Date(fromDate.getTime());
    }

    public void setToDate(Date toDate) {
        this.endDate = new Date(toDate.getTime());
    }

    public void setSymbol(String symbol) {
        this.security = symbol;
    }

    public void setClearing(String clearing) {
        this.clearingType = clearing;
    }

    public void setClient(String clientCode) {
        this.client = clientCode;
    }

    public void setSubCode(String code) {
        this.subCode = code;
    }

    public String getBranchCode() {
        return this.branchCode;
    }

    public void setBranchCode(String branchCode) {
        this.branchCode = branchCode;
    }

    public String getClientGroup() {
        return this.clientGroup;
    }

    public void setClientGroup(String clientGroup) {
        this.clientGroup = clientGroup;
    }

    public void setTraderCode(String traderCode) {
        this.traderCode = traderCode;
    }

    public String getTraderCode() {
        return this.traderCode;
    }

    @Override
    public String toXML() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        dateFormat.setLenient(false);
        StringBuffer xml = new StringBuffer("<Class name=\"ReportRequest\"><RNO>" + this.reportNo + "</" + TAG_reportNo + ">" + "<" + TAG_startDate + ">" + dateFormat.format(this.startDate) + "</" + TAG_startDate + ">" + "<" + TAG_endDate + ">" + dateFormat.format(this.endDate) + "</" + TAG_endDate + ">");
        if (this.security != null) {
            xml.append("<SEC><![CDATA[" + this.security + "]]>" + "</" + TAG_security + ">");
        }
        if (this.clearingType != null && !this.clearingType.equals("")) {
            xml.append("<CTP><![CDATA[" + this.clearingType + "]]>" + "</" + TAG_clearingType + ">");
        }
        if (this.client != null && !this.client.equals("")) {
            xml.append("<CLI><![CDATA[" + this.client + "]]>" + "</" + TAG_client + ">");
        }
        xml.append("</Class>");
        return xml.toString();
    }
}

