/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import pk.com.softech.messages.Message;
import pk.com.softech.messages.PortfolioData;

public class PortfolioResponse
extends Message {
    private static final long serialVersionUID = 100065L;
    PortfolioData[] rows;
    int filled;
    private boolean checkClearingType;
    private String clearingType;
    private String clientCode;
    private String responseMessage;
    public static final String TAG_filled = "FLD";
    public static final String TAG_checkClearingType = "CCT";
    public static final String TAG_clearingType = "CLT";
    public static final String TAG_rows = "ROW";

    public PortfolioResponse(String clientCode, String clearingType, boolean checkClearingType, int size) {
        super(411);
        this.rows = new PortfolioData[size];
        this.filled = 0;
        this.setClientCode(clientCode);
        this.setCheckClearingType(checkClearingType);
        this.setClearingType(clearingType);
    }

    public PortfolioResponse(int size) {
        super(411);
        this.rows = new PortfolioData[size];
        this.filled = 0;
    }

    public PortfolioResponse(String clearingType, boolean checkClearingType, PortfolioData[] rws) {
        super(411);
        this.filled = 0;
        if (rws != null) {
            this.rows = new PortfolioData[rws.length];
            System.arraycopy(rws, 0, this.rows, 0, rws.length);
            this.filled = rws.length;
        }
        this.setCheckClearingType(checkClearingType);
        this.setClearingType(clearingType);
    }

    public void addPortfolioData(PortfolioData data) throws ArrayIndexOutOfBoundsException {
        this.rows[this.filled++] = data;
    }

    public PortfolioData[] getrows() {
        return this.rows;
    }

    public boolean getCheckClearingType() {
        return this.checkClearingType;
    }

    public String getClearingType() {
        return this.clearingType;
    }

    public void setCheckClearingType(boolean checkClearingType) {
        this.checkClearingType = checkClearingType;
    }

    public void setClearingType(String clearingType) {
        this.clearingType = clearingType;
    }

    public void setClientCode(String clientCode) {
        this.clientCode = clientCode;
    }

    public String getClientCode() {
        return this.clientCode;
    }

    public void setResponseMessage(String responseMessage) {
        this.responseMessage = responseMessage;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    @Override
    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"PortfolioResponse\"><FLD>" + this.filled + "</" + TAG_filled + ">" + "<" + TAG_checkClearingType + ">" + this.checkClearingType + "</" + TAG_checkClearingType + ">");
        if (this.clearingType != null && !this.clearingType.equals("")) {
            xml.append("<CLT><![CDATA[" + this.clearingType + "]]>" + "</" + TAG_clearingType + ">");
        }
        int i = 0;
        while (i < this.filled) {
            if (this.rows[i] != null) {
                xml.append("<ROW>" + this.rows[i].toXML() + "</" + TAG_rows + ">");
            }
            ++i;
        }
        xml.append("</Class>");
        return xml.toString();
    }
}

