/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import pk.com.softech.messages.Message;
import pk.com.softech.messages.OrderData;

public class PendingOrderResponse
extends Message {
    private static final long serialVersionUID = 100061L;
    OrderData[] rows = null;
    int filled;
    int responseType;
    public static final String TAG_filled = "FLD";
    public static final String TAG_rows = "ROW";
    public static final String TAG_responseType = "RTY";

    public PendingOrderResponse(int size) {
        super(406);
        this.rows = new OrderData[size];
        this.filled = 0;
    }

    public PendingOrderResponse(int size, int responseType) {
        super(406);
        this.rows = new OrderData[size];
        this.filled = 0;
        this.setResponseType(responseType);
    }

    public PendingOrderResponse(OrderData[] rows, int responseType) {
        super(406);
        this.filled = 0;
        if (rows != null) {
            this.rows = new OrderData[rows.length];
            System.arraycopy(rows, 0, this.rows, 0, rows.length);
            this.filled = rows.length;
        }
        this.setResponseType(responseType);
    }

    public void addPendingOrder(OrderData data) throws ArrayIndexOutOfBoundsException {
        this.rows[this.filled++] = data;
    }

    public OrderData[] getrows() {
        return this.rows;
    }

    public int getFilled() {
        return this.filled;
    }

    public int getResponseType() {
        return this.responseType;
    }

    public void setResponseType(int responseType) {
        this.responseType = responseType;
    }

    public String formatString() {
        return "";
    }

    @Override
    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"PendingOrderResponse\"><FLD>" + this.filled + "</" + TAG_filled + ">");
        int i = 0;
        while (i < this.filled) {
            if (this.rows[i] != null) {
                xml.append("<ROW>" + this.rows[i].toXML() + "</" + TAG_rows + ">");
            }
            ++i;
        }
        xml.append("<RTY>" + this.responseType + "</" + TAG_responseType + ">" + "</Class>");
        return xml.toString();
    }
}

