/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import pk.com.softech.messages.Message;
import pk.com.softech.messages.OrderTypeData;

public class OrderTypeResponse
extends Message {
    private static final long serialVersionUID = 100059L;
    OrderTypeData[] rows;
    int filled;
    public static final String TAG_filled = "FLD";
    public static final String TAG_rows = "ROW";

    public OrderTypeResponse(int size) {
        super(403);
        this.rows = new OrderTypeData[size];
        this.filled = 0;
    }

    public OrderTypeResponse(OrderTypeData[] rows) {
        this(rows.length);
        System.arraycopy(rows, 0, this.rows, 0, rows.length);
        this.filled = rows.length;
    }

    public void addOrderType(OrderTypeData data) throws ArrayIndexOutOfBoundsException {
        this.rows[this.filled++] = data;
    }

    public OrderTypeData[] getrows() {
        return this.rows;
    }

    public String formatString() {
        String result = "TR|";
        int x = 0;
        while (x < this.rows.length) {
            result = String.valueOf(result) + this.rows[x].formatString(";") + "|";
            ++x;
        }
        return result;
    }

    @Override
    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"OrderTypeResponse\"><FLD>" + this.filled + "</" + TAG_filled + ">");
        int i = 0;
        while (i < this.filled) {
            if (this.rows[i] != null) {
                xml.append("<ROW>" + this.rows[i].toXML() + "</" + TAG_rows + ">");
            }
            ++i;
        }
        xml.append("</Class>");
        return xml.toString();
    }
}

