/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import pk.com.softech.messages.Message;
import pk.com.softech.messages.OrderMessage;

public class OrderRejection
extends Message {
    private static final long serialVersionUID = 100056L;
    protected OrderMessage order;
    protected String remarks;
    public static final String TAG_order = "ORD";
    public static final String TAG_remarks = "REM";

    public OrderRejection(OrderMessage order, String remarks) {
        super(113);
        this.setOrder(order);
        this.setRemarks(remarks);
    }

    public OrderRejection() {
        super(113);
    }

    public void setOrder(OrderMessage order) {
        this.order = order;
    }

    public OrderMessage getOrder() {
        return this.order;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public String formatString() {
        return "OJ| ORDER " + this.order.getNumber() + " REJECTED BECAUSE OF " + this.getRemarks();
    }

    @Override
    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"OrderRejection\">");
        if (this.order != null) {
            xml.append("<ORD>" + this.order.toXML() + "</" + TAG_order + ">");
        }
        if (this.remarks != null && !this.remarks.equals("")) {
            xml.append("<REM><![CDATA[" + this.remarks + "]]>" + "</" + TAG_remarks + ">");
        }
        xml.append("</Class>");
        return xml.toString();
    }
}

