/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import pk.com.softech.messages.Message;
import pk.com.softech.messages.OrderPropertyData;

public class OrderPropertyResponse
extends Message {
    private static final long serialVersionUID = 100055L;
    OrderPropertyData[] rows;
    int filled;
    public static final String TAG_filled = "FLD";
    public static final String TAG_rows = "ROW";

    public OrderPropertyResponse(int size) {
        super(404);
        this.rows = new OrderPropertyData[size];
        this.filled = 0;
    }

    public OrderPropertyResponse(OrderPropertyData[] rows) {
        this(rows.length);
        System.arraycopy(rows, 0, this.rows, 0, rows.length);
        this.filled = rows.length;
    }

    public void addOrderProperty(OrderPropertyData data) throws ArrayIndexOutOfBoundsException {
        this.rows[this.filled++] = data;
    }

    public OrderPropertyData[] getrows() {
        return this.rows;
    }

    public String formatString() {
        String result = "PR|";
        int x = 0;
        while (x < this.rows.length) {
            result = String.valueOf(result) + this.rows[x].formatString(";") + "|";
            ++x;
        }
        return result;
    }

    @Override
    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"OrderPropertyResponse\"><FLD>" + this.filled + "</" + TAG_filled + ">");
        int i = 0;
        while (i < this.filled) {
            if (this.rows[i] != null) {
                xml.append("<ROW>" + this.rows[i].toXML() + "</" + TAG_rows + ">");
            }
            ++i;
        }
        xml.append("</Class>");
        return xml.toString();
    }
}

