/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import java.text.SimpleDateFormat;
import java.util.Date;
import pk.com.softech.messages.Message;

public class OrderMessage
extends Message {
    private static final long serialVersionUID = 100052L;
    public static final int NEW = 0;
    public static final int MODIFY = 1;
    public static final int CANCEL = 2;
    public static final int SUSPEND = 3;
    public static final int RESUME = 4;
    public static final int STATUS = 5;
    public static final String[] actionNames = new String[]{"NEW", "MODIFY", "CANCEL", "SUSPEND", "RESUME", "STATUS"};
    public static final int BID = 0;
    public static final int OFFER = 1;
    public static final int HIT = 2;
    public static final int TAKE = 3;
    public static final int CROSS = 4;
    public static final String[] sideNames = new String[]{"BUY", "SELL", "HIT", "TAKE", "CROSS"};
    public static final int NONE = 0;
    public static final int ALL_OR_NONE = 1;
    public static final int FILL_OR_KILL = 2;
    public static final int MARKET = 3;
    public static final int LIMIT = 4;
    public static final int STOP_LOSS = 5;
    public static final int MARKET_IF_TOUCH = 6;
    public static final int UNPRICED = 7;
    public static final int SHORT_SELL = 8;
    public static final int LEVERAGE_BUY = 9;
    public static final int STOP_LOSS_MARKET = 10;
    public static final int MFS_BUY = 11;
    public static final int LEVERAGE_SELL = 12;
    public static final int MFS_SELL = 13;
    public static final String[] propertyNames = new String[]{"NONE", "AON", "FOK", "MARKET", "LIMIT", "STOP LOSS", "MIT", "UPR", "SHORT SELL", "LEVERAGE BUY", "S/L MARKET", "MFB", "LEVERAGE SELL", "MFS", "MSF", "BLANK SELL", "MKT TO LIMIT"};
    public static final String INVALID_SIDE = "Invalid order side, should be either BID or OFFER.";
    public static final String INVALID_PROPERTY = "Invalid order property, should be either NONE, ALL OR NONE or FILL OR KILL.";
    public static final String INVALID_TYPE = "Invalid order type, should be either MARKET, LIMIT or STOP_LOSS.";
    public static final String TAG_userId = "UID";
    public static final String TAG_action = "ACT";
    public static final String TAG_number = "NUM";
    public static final String TAG_market = "MKT";
    public static final String TAG_symbol = "SYM";
    public static final String TAG_member = "MEM";
    public static final String TAG_trader = "TRD";
    public static final String TAG_price = "PRC";
    public static final String TAG_oldPrice = "OPR";
    public static final String TAG_triggerPrice = "TPR";
    public static final String TAG_expiryDate = "EDT";
    public static final String TAG_buyClient = "BCL";
    public static final String TAG_buyOrderNumber = "BON";
    public static final String TAG_sellClient = "SCL";
    public static final String TAG_sellOrderNumber = "SON";
    public static final String TAG_property = "PRP";
    public static final String TAG_orderType = "OTP";
    public static final String TAG_volume = "VOL";
    public static final String TAG_originalVolume = "OVL";
    public static final String TAG_executedVolume = "EVL";
    public static final String TAG_disclosedVolume = "DVL";
    public static final String TAG_side = "SDE";
    public static final String TAG_referenceNumber = "RNO";
    public static final String TAG_marginOverride = "MRO";
    public static final String TAG_clientUin = "CUI";
    public static final String TAG_multiplier = "MUL";
    public static final String TAG_goodTillCancel = "GTC";
    protected String userId;
    protected int action;
    protected int number;
    protected String market;
    protected String symbol;
    protected String member;
    protected String trader;
    protected float price;
    protected float oldPrice;
    protected float triggerPrice;
    protected Date expiryDate;
    protected String buyClient;
    protected int buyOrderNumber;
    protected String sellClient;
    protected int sellOrderNumber;
    protected int property;
    protected int orderType;
    protected int volume;
    protected int originalVolume;
    protected int executedVolume;
    protected int disclosedVolume;
    protected int side;
    protected String referenceNumber;
    protected int oldVolume;
    protected boolean marginOverride;
    protected int orignalOrderNumber;
    protected String clientUIN;
    protected int afterHourOrder;
    protected int multiplier;
    protected int goodTillCancel = 0;
    protected int goodTillDate = 0;
    protected String gtcOrderNumber;
    private boolean byPassMargin;
    private String lpId;
    private boolean fixOrder;
    protected String exchOrderNumber;
    protected String remarks;
    protected String orderSource;
    protected boolean partyOrder;
    protected String custodianMemberCode;
    private String extExchSeq;
    private String exchSeqId;
    private String extUserId;
    private String extRemarks;
    private Integer parentSeqId = 0;
    private boolean isParentOrder;
    private boolean orderOnHold;
    private char executionType;
    private String onBehalfOfCompID;
    private String senderCompID;
    private String senderSubId;

    public OrderMessage(String userId, int action, int number, String market, String symbol, String member, String trader, float price, float oldPrice, float triggerPrice, Date expiryDate, String buyClient, int buyOrderNumber, String sellClient, int sellOrderNumber, int property, int orderType, int volume, int originalVolume, int disclosedVolume, int side) {
        this(userId, action, number, market, symbol, member, trader, price, oldPrice, triggerPrice, expiryDate, buyClient, buyOrderNumber, sellClient, sellOrderNumber, property, orderType, volume, originalVolume, disclosedVolume, side, "0");
    }

    public OrderMessage(String userId, int action, int number, String market, String symbol, String member, String trader, float price, float oldPrice, float triggerPrice, Date expiryDate, String buyClient, int buyOrderNumber, String sellClient, int sellOrderNumber, int property, int orderType, int volume, int originalVolume, int disclosedVolume, int side, String referenceNumber) {
        this(userId, action, number, market, symbol, member, trader, price, oldPrice, triggerPrice, expiryDate, buyClient, buyOrderNumber, sellClient, sellOrderNumber, property, orderType, volume, originalVolume, disclosedVolume, side, referenceNumber, 0, 0, 0);
    }

    public OrderMessage(String userId, int action, int number, String market, String symbol, String member, String trader, float price, float oldPrice, float triggerPrice, Date expiryDate, String buyClient, int buyOrderNumber, String sellClient, int sellOrderNumber, int property, int orderType, int volume, int originalVolume, int disclosedVolume, int side, String referenceNumber, int oldVolume, int afterHourOrder, int goodTillCancel) {
        super(11);
        this.setUserId(userId);
        this.setAction(action);
        this.setNumber(number);
        this.setMarket(market);
        this.setSymbol(symbol);
        this.setMember(member);
        this.setTrader(trader);
        this.setPrice(price);
        this.setOldPrice(oldPrice);
        this.setTriggerPrice(triggerPrice);
        this.setExpiryDate(expiryDate);
        this.setBuyClient(buyClient);
        this.setBuyOrderNumber(buyOrderNumber);
        this.setSellClient(sellClient);
        this.setSellOrderNumber(sellOrderNumber);
        this.setProperty(property);
        this.setOrderType(orderType);
        this.setVolume(volume);
        this.setOriginalVolume(originalVolume);
        this.setDisclosedVolume(disclosedVolume);
        this.setSide(side);
        this.setReferenceNumber(referenceNumber);
        this.setOldVolume(oldVolume);
        this.setMarginOverride(false);
        this.setAfterHourOrder(afterHourOrder);
        this.setGoodTillCancel(goodTillCancel);
    }

    public OrderMessage(OrderMessage order) {
        this.setUserId(order.getUserId());
        this.setTimeStamp(order.getTimeStamp());
        this.setType(order.getType());
        this.setAction(order.getAction());
        this.setNumber(order.getNumber());
        this.setMarket(order.getMarket());
        this.setSymbol(order.getSymbol());
        this.setMember(order.getMember());
        this.setTrader(order.getTrader());
        this.setPrice(order.getPrice());
        this.setOldPrice(order.getOldPrice());
        this.setTriggerPrice(order.getTriggerPrice());
        this.setExpiryDate(order.getExpiryDate());
        this.setBuyClient(order.getBuyClient());
        this.setBuyOrderNumber(order.getBuyOrderNumber());
        this.setSellClient(order.getSellClient());
        this.setSellOrderNumber(order.getSellOrderNumber());
        this.setProperty(order.getProperty());
        this.setOrderType(order.getOrderType());
        this.setVolume(order.getVolume());
        this.setOriginalVolume(order.getOriginalVolume());
        this.setExecutedVolume(order.getExecutedVolume());
        this.setDisclosedVolume(order.getDisclosedVolume());
        this.setSide(order.getSide());
        this.setReferenceNumber(order.getReferenceNumber());
        this.setMarginOverride(order.getMarginOverride());
        this.setOrignalOrderNumber(order.getOrignalOrderNumber());
        this.setClientUIN(order.getClientUIN());
        this.setAfterHourOrder(order.getAfterHourOrder());
        this.setStExCode(order.getStExCode());
        this.setGoodTillCancel(order.getGoodTillCancel());
        this.setExtExchSeq(order.getExtExchSeq());
        this.setExtUserId(order.getExtUserId());
        this.setExchSeqId(order.getExchSeqId());
        this.setParentSeqId(order.getParentSeqId());
    }

    public OrderMessage() {
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setAction(int action) {
        if (action != 0 && action != 1 && action != 2 && action != 3 && action != 4 && action != 5) {
            throw new IllegalArgumentException();
        }
        this.action = action;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public void reStamp() {
        this.timeStamp = new Date();
    }

    public void setMarket(String market) {
        this.market = market;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public void setMember(String member) {
        this.member = member;
    }

    public void setTrader(String trader) {
        this.trader = trader;
    }

    public void setPrice(float price) {
        this.price = price;
    }

    public void setOldPrice(float oldPrice) {
        this.oldPrice = oldPrice;
    }

    public void setTriggerPrice(float triggerPrice) {
        this.triggerPrice = triggerPrice;
    }

    public void setExpiryDate(Date expiryDate) {
        this.expiryDate = expiryDate;
    }

    public void setBuyClient(String buyClient) {
        this.buyClient = buyClient;
    }

    public void setBuyOrderNumber(int buyOrderNumber) {
        this.buyOrderNumber = buyOrderNumber;
    }

    public void setSellClient(String sellClient) {
        this.sellClient = sellClient;
    }

    public void setSellOrderNumber(int sellOrderNumber) {
        this.sellOrderNumber = sellOrderNumber;
    }

    public void setProperty(int property) {
        this.property = property;
    }

    public void setOrderType(int orderType) {
        this.orderType = orderType;
    }

    public void setVolume(int volume) {
        this.volume = volume;
    }

    public void setOriginalVolume(int originalVolume) {
        this.originalVolume = originalVolume;
    }

    public void setExecutedVolume(int exeVol) {
        this.executedVolume = exeVol;
    }

    public void setDisclosedVolume(int disclosedVolume) {
        this.disclosedVolume = disclosedVolume;
    }

    public void reduceVolume(int volume) {
        if (volume <= this.volume) {
            this.volume -= volume;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void setSide(int side) {
        if (side != 0 && side != 1 && side != 2 && side != 3 && side != 4) {
            throw new IllegalArgumentException(INVALID_SIDE);
        }
        this.side = side;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    public void setAfterHourOrder(int afterHourOrder) {
        this.afterHourOrder = afterHourOrder;
    }

    public void setOldVolume(int oldVolume) {
        this.oldVolume = oldVolume;
    }

    public void setMarginOverride(boolean marginOverride) {
        this.marginOverride = marginOverride;
    }

    public void setOrignalOrderNumber(int orignalOrderNumber) {
        this.orignalOrderNumber = orignalOrderNumber;
    }

    public void setClientUIN(String clientUIN) {
        this.clientUIN = clientUIN;
    }

    public void setMultiplier(int multiplier) {
        this.multiplier = multiplier;
    }

    public void setGoodTillCancel(int goodTillCancel) {
        this.goodTillCancel = goodTillCancel;
    }

    public int getGoodTillDate() {
        return this.goodTillDate;
    }

    public void setGoodTillDate(int goodTillDate) {
        this.goodTillDate = goodTillDate;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public String getUserId() {
        return this.userId;
    }

    public int getAction() {
        return this.action;
    }

    public int getNumber() {
        return this.number;
    }

    public String getMarket() {
        return this.market;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public int getSide() {
        return this.side;
    }

    public String getSideName() {
        return sideNames[this.side];
    }

    public String getMember() {
        return this.member;
    }

    public String getTrader() {
        return this.trader;
    }

    public float getPrice() {
        return this.price;
    }

    public float getOldPrice() {
        return this.oldPrice;
    }

    public float getTriggerPrice() {
        return this.triggerPrice;
    }

    public Date getExpiryDate() {
        return this.expiryDate;
    }

    public String getBuyClient() {
        return this.buyClient;
    }

    public int getBuyOrderNumber() {
        return this.buyOrderNumber;
    }

    public String getSellClient() {
        return this.sellClient;
    }

    public int getSellOrderNumber() {
        return this.sellOrderNumber;
    }

    public int getProperty() {
        return this.property;
    }

    public int getOrderType() {
        return this.orderType;
    }

    public int getVolume() {
        return this.volume;
    }

    public int getOriginalVolume() {
        return this.originalVolume;
    }

    public int getExecutedVolume() {
        return this.executedVolume;
    }

    public int getDisclosedVolume() {
        return this.disclosedVolume;
    }

    public int getAfterHourOrder() {
        return this.afterHourOrder;
    }

    public boolean isBuy() {
        return this.getSide() == 0 || this.getSide() == 3 || this.getSide() == 4;
    }

    public int getHouseOrderNumber() {
        if (this.isBuy()) {
            return this.getBuyOrderNumber();
        }
        return this.getSellOrderNumber();
    }

    public void setHouseOrderNumber(int number) {
        if (this.isBuy()) {
            this.setBuyOrderNumber(number);
        } else {
            this.setSellOrderNumber(number);
        }
    }

    public String getOrderClient() {
        if (this.isBuy()) {
            return this.getBuyClient();
        }
        return this.getSellClient();
    }

    public void setOrderClient(String client) {
        if (this.isBuy()) {
            this.setBuyClient(client);
        } else {
            this.setSellClient(client);
        }
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public int getOldVolume() {
        return this.oldVolume;
    }

    public boolean getMarginOverride() {
        return this.marginOverride;
    }

    public int getOrignalOrderNumber() {
        return this.orignalOrderNumber;
    }

    public String getClientUIN() {
        return this.clientUIN;
    }

    public int getGoodTillCancel() {
        return this.goodTillCancel;
    }

    public boolean isSell() {
        return this.getSide() == 1 || this.getSide() == 2 || this.getSide() == 4;
    }

    public String getGtcOrderNumber() {
        return this.gtcOrderNumber;
    }

    public void setGtcOrderNumber(String gtcOrderNumber) {
        this.gtcOrderNumber = gtcOrderNumber;
    }

    public void setByPassMargin(boolean byPassMargin) {
        this.byPassMargin = byPassMargin;
    }

    public boolean isByPassMargin() {
        return this.byPassMargin;
    }

    public void setLpId(String lpId) {
        this.lpId = lpId;
    }

    public String getLpId() {
        return this.lpId;
    }

    public void setExtExchSeq(String extExchSeq) {
        this.extExchSeq = extExchSeq;
        System.out.println("OrderMessage:804  = exchSeqId " + this.exchSeqId + " extExchSeq :  " + extExchSeq);
    }

    public String getExtExchSeq() {
        return this.extExchSeq;
    }

    public void setExtUserId(String extUserId) {
        this.extUserId = extUserId;
    }

    public String getExtUserId() {
        return this.extUserId;
    }

    public void setExchSeqId(String exchSeqId) {
        this.exchSeqId = exchSeqId;
    }

    public String getExchSeqId() {
        return this.exchSeqId;
    }

    public void setExchRemarks(String extRemarks) {
        this.extRemarks = extRemarks;
    }

    public String getExtRemarks() {
        return this.extRemarks;
    }

    public void setFixOrder(boolean fixOrder) {
        this.fixOrder = fixOrder;
    }

    public boolean isFixOrder() {
        return this.fixOrder;
    }

    public String getExchOrderNumber() {
        return this.exchOrderNumber;
    }

    public void setExchOrderNumber(String exchOrderNumber) {
        this.exchOrderNumber = exchOrderNumber;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getOrderSource() {
        return this.orderSource;
    }

    public void setOrderSource(String orderSource) {
        this.orderSource = orderSource;
    }

    public boolean isPartyOrder() {
        return this.partyOrder;
    }

    public void setPartyOrder(boolean partyOrder) {
        this.partyOrder = partyOrder;
    }

    public String getCustodianMemberCode() {
        return this.custodianMemberCode;
    }

    public void setCustodianMemberCode(String custodianMemberCode) {
        this.custodianMemberCode = custodianMemberCode;
    }

    public Integer getParentSeqId() {
        if (this.parentSeqId == null) {
            return 0;
        }
        return this.parentSeqId;
    }

    public void setParentSeqId(Integer parentSeqId) {
        this.parentSeqId = parentSeqId;
    }

    public boolean isParentOrder() {
        return this.isParentOrder;
    }

    public void setIsParentOrder(boolean isParentOrder) {
        this.isParentOrder = isParentOrder;
    }

    public boolean isOrderOnHold() {
        return this.orderOnHold;
    }

    public void setOrderOnHold(boolean orderOnHold) {
        this.orderOnHold = orderOnHold;
    }

    public char getExecutionType() {
        return this.executionType;
    }

    public void setExecutionType(char executionType) {
        this.executionType = executionType;
    }

    public String getOnBehalfOfCompID() {
        return this.onBehalfOfCompID;
    }

    public void setOnBehalfOfCompID(String onBehalfOfCompID) {
        this.onBehalfOfCompID = onBehalfOfCompID;
    }

    public String getSenderCompID() {
        return this.senderCompID;
    }

    public void setSenderCompID(String senderCompID) {
        this.senderCompID = senderCompID;
    }

    public String getSenderSubId() {
        return this.senderSubId;
    }

    public void setSenderSubId(String senderSubId) {
        this.senderSubId = senderSubId;
    }

    public String formatString() {
        return "OD|" + this.getAction() + "|" + this.getMarket() + "|" + this.getSymbol() + "|" + this.getMember() + "|" + this.getTrader() + "|" + this.getPrice() + "|" + this.getTriggerPrice() + "|" + this.getExpiryDate() + "|" + this.getBuyClient() + "|" + this.getSellClient() + "|" + this.getHouseOrderNumber() + "|" + this.getProperty() + "|" + this.getOrderType() + "|" + this.getVolume() + "|" + this.getSide() + "|" + this.getReferenceNumber() + "|" + this.getClientUIN() + "|" + this.getGoodTillCancel() + "|" + this.getGtcOrderNumber();
    }

    @Override
    public String toXML() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        dateFormat.setLenient(false);
        StringBuffer xml = new StringBuffer("<Class name=\"OrderMessage\">");
        if (this.userId != null && !this.userId.equals("")) {
            xml.append("<UID><![CDATA[" + this.userId + "]]>" + "</" + TAG_userId + ">");
        }
        xml.append("<ACT>" + this.action + "</" + TAG_action + ">" + "<" + TAG_number + ">" + this.number + "</" + TAG_number + ">");
        if (this.market != null && !this.market.equals("")) {
            xml.append("<MKT><![CDATA[" + this.market + "]]>" + "</" + TAG_market + ">");
        }
        if (this.symbol != null && !this.symbol.equals("")) {
            xml.append("<SYM><![CDATA[" + this.symbol + "]]>" + "</" + TAG_symbol + ">");
        }
        if (this.member != null && !this.member.equals("")) {
            xml.append("<MEM><![CDATA[" + this.member + "]]>" + "</" + TAG_member + ">");
        }
        if (this.trader != null && !this.trader.equals("")) {
            xml.append("<TRD><![CDATA[" + this.trader + "]]>" + "</" + TAG_trader + ">");
        }
        xml.append("<PRC>" + this.price + "</" + TAG_price + ">" + "<" + TAG_oldPrice + ">" + this.oldPrice + "</" + TAG_oldPrice + ">" + "<" + TAG_triggerPrice + ">" + this.triggerPrice + "</" + TAG_triggerPrice + ">" + "<" + TAG_expiryDate + ">" + dateFormat.format(this.expiryDate) + "</" + TAG_expiryDate + ">");
        if (this.buyClient != null && !this.buyClient.equals("")) {
            xml.append("<BCL><![CDATA[" + this.buyClient + "]]>" + "</" + TAG_buyClient + ">");
        }
        xml.append("<BON>" + this.buyOrderNumber + "</" + TAG_buyOrderNumber + ">");
        if (this.sellClient != null && !this.sellClient.equals("")) {
            xml.append("<SCL><![CDATA[" + this.sellClient + "]]>" + "</" + TAG_sellClient + ">");
        }
        xml.append("<SON>" + this.sellOrderNumber + "</" + TAG_sellOrderNumber + ">" + "<" + TAG_property + ">" + this.property + "</" + TAG_property + ">" + "<" + TAG_orderType + ">" + this.orderType + "</" + TAG_orderType + ">" + "<" + TAG_volume + ">" + this.volume + "</" + TAG_volume + ">" + "<" + TAG_originalVolume + ">" + this.originalVolume + "</" + TAG_originalVolume + ">" + "<" + TAG_executedVolume + ">" + this.executedVolume + "</" + TAG_executedVolume + ">" + "<" + TAG_disclosedVolume + ">" + this.disclosedVolume + "</" + TAG_disclosedVolume + ">" + "<" + TAG_side + ">" + this.side + "</" + TAG_side + ">" + "<" + TAG_referenceNumber + ">" + this.referenceNumber + "</" + TAG_referenceNumber + ">" + "<" + TAG_marginOverride + ">" + this.marginOverride + "</" + TAG_marginOverride + ">" + "<" + TAG_clientUin + ">" + this.clientUIN + "</" + TAG_clientUin + ">" + "</Class>");
        return xml.toString();
    }

    public String toString() {
        return "OrderMessage [userId=" + this.userId + ", action=" + this.action + ", number=" + this.number + ", market=" + this.market + ", symbol=" + this.symbol + ", member=" + this.member + ", trader=" + this.trader + ", price=" + this.price + ", oldPrice=" + this.oldPrice + ", triggerPrice=" + this.triggerPrice + ", expiryDate=" + this.expiryDate + ", buyClient=" + this.buyClient + ", buyOrderNumber=" + this.buyOrderNumber + ", sellClient=" + this.sellClient + ", sellOrderNumber=" + this.sellOrderNumber + ", property=" + this.property + ", orderType=" + this.orderType + ", volume=" + this.volume + ", originalVolume=" + this.originalVolume + ", executedVolume=" + this.executedVolume + ", disclosedVolume=" + this.disclosedVolume + ", side=" + this.side + ", referenceNumber=" + this.referenceNumber + ", oldVolume=" + this.oldVolume + ", marginOverride=" + this.marginOverride + ", orignalOrderNumber=" + this.orignalOrderNumber + ", clientUIN=" + this.clientUIN + ", afterHourOrder=" + this.afterHourOrder + ", multiplier=" + this.multiplier + ", goodTillCancel=" + this.goodTillCancel + ", gtcOrderNumber=" + this.gtcOrderNumber + ", byPassMargin=" + this.byPassMargin + ", lpId=" + this.lpId + ", fixOrder=" + this.fixOrder + ", exchOrderNumber=" + this.exchOrderNumber + ", remarks=" + this.remarks + ", extExchSeq=" + this.extExchSeq + ", extUserId=" + this.extUserId + ", extRemarks=" + this.extRemarks + ", exchSeqId=" + this.exchSeqId + ", parentSeqId=" + this.parentSeqId + ", isParentOrder=" + this.isParentOrder + ", orderOnHold=" + this.orderOnHold + ", executionType=" + this.executionType + "]";
    }
}

