/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import java.io.Serializable;
import java.util.Date;
import pk.com.softech.messages.OrderMessage;

public class OrderData
implements Serializable {
    private static final long serialVersionUID = 100051L;
    protected int number;
    protected Date timeStamp;
    protected String market;
    protected String symbol;
    protected float price;
    protected float triggerPrice;
    protected Date expiryDate;
    protected String buyClient;
    protected int buyOrderNumber;
    protected String sellClient;
    protected int sellOrderNumber;
    protected int property;
    protected int orderType;
    protected int volume;
    protected int executedVolume;
    protected int disclosedVolume;
    protected int side;
    protected String refNumber;
    protected String clientUIN;
    protected int post;
    protected int afterHourOrder;
    protected String exchange;
    protected int multiplier;
    protected String orderSource;
    protected int goodTillCancel = 0;
    protected String userId;
    protected int bbParentOrderId = 0;
    protected String exchOrgOrderId;
    protected String exchOrderSeq;
    public static final String TAG_number = "NUM";
    public static final String TAG_timeStamp = "TST";
    public static final String TAG_market = "MKT";
    public static final String TAG_symbol = "SYM";
    public static final String TAG_price = "PRC";
    public static final String TAG_triggerPrice = "TPR";
    public static final String TAG_expiryDate = "EDT";
    public static final String TAG_buyClient = "BCL";
    public static final String TAG_buyOrderNumber = "BON";
    public static final String TAG_sellClient = "SCL";
    public static final String TAG_sellOrderNumber = "SON";
    public static final String TAG_property = "PRP";
    public static final String TAG_orderType = "OTY";
    public static final String TAG_volume = "VOL";
    public static final String TAG_executedVolume = "EVL";
    public static final String TAG_disclosedVolume = "DVL";
    public static final String TAG_side = "SDE";
    public static final String TAG_refNumber = "REF";
    public static final String TAG_clientUIN = "CUI";
    public static final String TAG_post = "PST";
    public static final String TAG_afterHourOrder = "AHO";
    public static final String TAG_exchange = "EXC";
    public static final String TAG_multiplier = "MUL";

    public OrderData(int number, Date timeStamp, String market, String symbol, float price, float triggerPrice, Date expiryDate, String buyClient, int buyOrderNumber, String sellClient, int sellOrderNumber, int property, int orderType, int volume, int executedVolume, int disclosedVolume, int side, String refNumber, String clientUIN, int post, int afterHourOrder, String exchange, int multiplier, int goodTC) {
        this.setNumber(number);
        this.setTimeStamp(timeStamp);
        this.setMarket(market);
        this.setSymbol(symbol);
        this.setPrice(price);
        this.setTriggerPrice(triggerPrice);
        this.setExpiryDate(expiryDate);
        this.setBuyClient(buyClient);
        this.setBuyOrderNumber(buyOrderNumber);
        this.setSellClient(sellClient);
        this.setSellOrderNumber(sellOrderNumber);
        this.setProperty(property);
        this.setOrderType(orderType);
        this.setVolume(volume);
        this.setExecutedVolume(executedVolume);
        this.setDisclosedVolume(disclosedVolume);
        this.setSide(side);
        this.setRefNumber(refNumber);
        this.setClientUIN(clientUIN);
        this.setPost(post);
        this.setAfterHourOrder(afterHourOrder);
        this.setExchange(exchange);
        this.setMultiplier(multiplier);
        this.setGoodTillCancel(goodTC);
    }

    public OrderData(int number, Date timeStamp, String market, String symbol, float price, float triggerPrice, Date expiryDate, String buyClient, int buyOrderNumber, String sellClient, int sellOrderNumber, int property, int orderType, int volume, int executedVolume, int disclosedVolume, int side, String refNumber, String clientUIN, String exchange, int multiplier) {
        this(number, timeStamp, market, symbol, price, triggerPrice, expiryDate, buyClient, buyOrderNumber, sellClient, sellOrderNumber, property, orderType, volume, executedVolume, disclosedVolume, side, refNumber, clientUIN, 1, 0, exchange, multiplier, 0);
    }

    public OrderData() {
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void setMarket(String market) {
        this.market = market;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public void setPrice(float price) {
        this.price = price;
    }

    public void setTriggerPrice(float triggerPrice) {
        this.triggerPrice = triggerPrice;
    }

    public void setExpiryDate(Date expiryDate) {
        this.expiryDate = expiryDate;
    }

    public void setBuyClient(String buyClient) {
        this.buyClient = buyClient;
    }

    public void setBuyOrderNumber(int buyOrderNumber) {
        this.buyOrderNumber = buyOrderNumber;
    }

    public void setSellClient(String sellClient) {
        this.sellClient = sellClient;
    }

    public void setSellOrderNumber(int sellOrderNumber) {
        this.sellOrderNumber = sellOrderNumber;
    }

    public void setProperty(int property) {
        this.property = property;
    }

    public void setOrderType(int orderType) {
        this.orderType = orderType;
    }

    public void setVolume(int volume) {
        this.volume = volume;
    }

    public void setExecutedVolume(int executedVolume) {
        this.executedVolume = executedVolume;
    }

    public void setDisclosedVolume(int disclosedVolume) {
        this.disclosedVolume = disclosedVolume;
    }

    public void setSide(int side) {
        if (side != 0 && side != 1 && side != 4) {
            throw new IllegalArgumentException("Invalid order side, should be either BID or OFFER.");
        }
        this.side = side;
    }

    public void setMultiplier(int multiplier) {
        this.multiplier = multiplier;
    }

    public void setGoodTillCancel(int goodTillCancel) {
        this.goodTillCancel = goodTillCancel;
    }

    public int getGoodTillCancel() {
        return this.goodTillCancel;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public int getNumber() {
        return this.number;
    }

    public String getMarket() {
        return this.market;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public int getSide() {
        return this.side;
    }

    public String getSideName() {
        return OrderMessage.sideNames[this.side];
    }

    public float getPrice() {
        return this.price;
    }

    public float getTriggerPrice() {
        return this.triggerPrice;
    }

    public Date getExpiryDate() {
        return this.expiryDate;
    }

    public String getBuyClient() {
        return this.buyClient;
    }

    public int getBuyOrderNumber() {
        return this.buyOrderNumber;
    }

    public String getSellClient() {
        return this.sellClient;
    }

    public int getSellOrderNumber() {
        return this.sellOrderNumber;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public int getHouseOrderNumber() {
        if (this.side == 0 || this.side == 3) {
            return this.getBuyOrderNumber();
        }
        if (this.side == 1 || this.side == 2) {
            return this.getSellOrderNumber();
        }
        throw new RuntimeException("Cross order");
    }

    public int getProperty() {
        return this.property;
    }

    public int getOrderType() {
        return this.orderType;
    }

    public int getVolume() {
        return this.volume;
    }

    public int getExecutedVolume() {
        return this.executedVolume;
    }

    public int getDisclosedVolume() {
        return this.disclosedVolume;
    }

    public void setRefNumber(String refNumber) {
        this.refNumber = refNumber;
    }

    public String getRefNumber() {
        return this.refNumber;
    }

    public void setClientUIN(String clientUIN) {
        this.clientUIN = clientUIN;
    }

    public String getclientUIN() {
        return this.clientUIN;
    }

    public void setPost(int post) {
        this.post = post;
    }

    public int getPost() {
        return this.post;
    }

    public void setAfterHourOrder(int afterHourOrder) {
        this.afterHourOrder = afterHourOrder;
    }

    public int getAfterHourOrder() {
        return this.afterHourOrder;
    }

    public String getExchange() {
        return this.exchange;
    }

    public void setExchange(String exchange) {
        this.exchange = exchange;
    }

    public String getOrderSource() {
        return this.orderSource;
    }

    public void setOrderSource(String orderSource) {
        this.orderSource = orderSource;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public int getBbParentOrderId() {
        return this.bbParentOrderId;
    }

    public void setBbParentOrderId(int bbParentOrderId) {
        this.bbParentOrderId = bbParentOrderId;
    }

    public String getExchOrgOrderId() {
        return this.exchOrgOrderId;
    }

    public void setExchOrgOrderId(String exchOrgOrderId) {
        this.exchOrgOrderId = exchOrgOrderId;
    }

    public String getExchOrderSeq() {
        return this.exchOrderSeq;
    }

    public void setExchOrderSeq(String exchOrderSeq) {
        this.exchOrderSeq = exchOrderSeq;
    }

    public boolean isBBOrder() {
        return this.exchOrgOrderId != null && this.exchOrgOrderId.isEmpty();
    }

    public boolean isBBParentOrder() {
        return this.isBBOrder() && this.getBbParentOrderId() != 0;
    }

    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"OrderData\"><NUM>" + this.number + "</" + TAG_number + ">" + "<" + TAG_timeStamp + ">" + this.timeStamp.toString() + "</" + TAG_timeStamp + ">");
        if (this.market != null && !this.market.equals("")) {
            xml.append("<MKT><![CDATA[" + this.market + "]]>" + "</" + TAG_market + ">");
        }
        if (this.symbol != null && !this.symbol.equals("")) {
            xml.append("<SYM><![CDATA[" + this.symbol + "]]>" + "</" + TAG_symbol + ">");
        }
        xml.append("<PRC>" + this.price + "</" + TAG_price + ">" + "<" + TAG_triggerPrice + ">" + this.triggerPrice + "</" + TAG_triggerPrice + ">" + "<" + TAG_expiryDate + ">" + this.expiryDate.toString() + "</" + TAG_expiryDate + ">");
        if (this.buyClient != null && !this.buyClient.equals("")) {
            xml.append("<BCL><![CDATA[" + this.buyClient + "]]>" + "</" + TAG_buyClient + ">");
        }
        xml.append("<BON>" + this.buyOrderNumber + "</" + TAG_buyOrderNumber + ">");
        if (this.sellClient != null && !this.sellClient.equals("")) {
            xml.append("<SCL><![CDATA[" + this.sellClient + "]]>" + "</" + TAG_sellClient + ">");
        }
        xml.append("<SON>" + this.sellOrderNumber + "</" + TAG_sellOrderNumber + ">" + "<" + TAG_property + ">" + this.property + "</" + TAG_property + ">" + "<" + TAG_orderType + ">" + this.orderType + "</" + TAG_orderType + ">" + "<" + TAG_volume + ">" + this.volume + "</" + TAG_volume + ">" + "<" + TAG_executedVolume + ">" + this.executedVolume + "</" + TAG_executedVolume + ">" + "<" + TAG_disclosedVolume + ">" + this.disclosedVolume + "</" + TAG_disclosedVolume + ">" + "<" + TAG_side + ">" + this.side + "</" + TAG_side + ">" + "<" + TAG_refNumber + ">" + this.refNumber + "</" + TAG_refNumber + ">" + "<" + TAG_clientUIN + ">" + this.clientUIN + "</" + TAG_clientUIN + ">" + "</Class>");
        return xml.toString();
    }
}

