/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import java.util.Date;
import pk.com.softech.messages.Message;
import pk.com.softech.messages.OrderMessage;

public class OrderConfirmation
extends Message {
    private static final long serialVersionUID = 100050L;
    public static int ACCEPT = 0;
    public static int QUEUE = 1;
    public static int REJECT = 2;
    public static int ACTIVATE = 3;
    public static int RECEIVED = 4;
    public static int SAVED = 5;
    protected OrderMessage order;
    protected int action;
    protected String remarks;
    public static final String TAG_order = "ORD";
    public static final String TAG_action = "ACT";
    public static final String TAG_remarks = "REM";

    public OrderConfirmation(OrderMessage order, int action, String remarks) {
        super(111);
        this.setOrder(order);
        this.setAction(action);
        this.setRemarks(remarks);
    }

    public OrderConfirmation(OrderMessage order, int action, String remarks, Date timeStamp) {
        this(order, action, remarks);
        this.setTimeStamp(timeStamp);
    }

    public OrderConfirmation() {
        super(111);
    }

    public void setOrder(OrderMessage order) {
        this.order = order;
    }

    public OrderMessage getOrder() {
        return this.order;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setAction(int action) {
        if (action != ACCEPT && action != REJECT && action != ACTIVATE && action != RECEIVED && action != QUEUE && action != SAVED) {
            throw new IllegalArgumentException();
        }
        this.action = action;
    }

    public int getAction() {
        return this.action;
    }

    public String buildMessage() {
        return this.getRemarks();
    }

    public String formatString() {
        return "OC|" + this.buildMessage();
    }

    @Override
    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"OrderConfirmation\">");
        if (this.order != null) {
            xml.append("<ORD>" + this.order.toXML() + "</" + TAG_order + ">");
        }
        xml.append("<ACT>" + this.action + "</" + TAG_action + ">");
        if (this.remarks != null && !this.remarks.equals("")) {
            xml.append("<REM><![CDATA[" + this.remarks + "]]>" + "</" + TAG_remarks + ">");
        }
        xml.append("</Class>");
        return xml.toString();
    }
}

