/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import pk.com.softech.messages.Message;

public class NotificationResponse
extends Message {
    private static final long serialVersionUID = 100049L;
    public static final int SUCCESSFUL = 1;
    public static final int FAILED = 2;
    protected int action;
    protected String remarks;
    public static final String TAG_action = "ACT";
    public static final String TAG_remarks = "REM";

    public NotificationResponse(int act, String rem) {
        super(0);
        this.setAction(act);
        this.setRemarks(rem);
    }

    public NotificationResponse() {
        super(0);
    }

    public void setAction(int act) {
        switch (act) {
            case 1: 
            case 2: {
                this.action = act;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid notification response action.");
            }
        }
    }

    public int getAction() {
        return this.action;
    }

    public void setRemarks(String rem) {
        this.remarks = rem;
    }

    public String getRemarks() {
        return this.remarks;
    }

    @Override
    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"NotificationResponse\"><ACT>" + this.action + "</" + TAG_action + ">");
        if (this.remarks != null && !this.remarks.equals("")) {
            xml.append("<REM><![CDATA[" + this.remarks + "]]>" + "</" + TAG_remarks + ">");
        }
        xml.append("</Class>");
        return xml.toString();
    }
}

