/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import pk.com.softech.messages.Message;

public class NetOffMarginResponse
extends Message {
    private static final long serialVersionUID = 100047L;
    public static final int CALCULATE_MARGIN = 1;
    public static final int NOTIFY_CLIENTS = 2;
    public static final int SQUAREUP_POSITIONS = 3;
    public static final int SUCCESSFUL = 1;
    public static final int FAILED = 2;
    protected int marginResponseNo;
    protected int action;
    protected String remarks;
    public static final String TAG_marginResponseNo = "MRN";
    public static final String TAG_action = "ACT";
    public static final String TAG_remarks = "REM";

    public NetOffMarginResponse(int marginResponseType, int act, String rem) {
        super(0);
        this.setMarginResponseType(marginResponseType);
        this.setAction(act);
        this.setRemarks(rem);
    }

    public NetOffMarginResponse() {
        super(0);
    }

    public void setAction(int act) {
        switch (act) {
            case 1: 
            case 2: {
                this.action = act;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid net off margin response action.");
            }
        }
    }

    public int getAction() {
        return this.action;
    }

    public void setRemarks(String rem) {
        this.remarks = rem;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setMarginResponseType(int marginResponseType) {
        switch (marginResponseType) {
            case 1: 
            case 2: 
            case 3: {
                this.marginResponseNo = marginResponseType;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid margin response type.");
            }
        }
    }

    public int getMarginResponseType() {
        return this.marginResponseNo;
    }

    @Override
    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"NetOffMarginResponse\"><MRN>" + this.marginResponseNo + "</" + TAG_marginResponseNo + ">" + "<" + TAG_action + ">" + this.action + "</" + TAG_action + ">");
        if (this.remarks != null && !this.remarks.equals("")) {
            xml.append("<REM><![CDATA[" + this.remarks + "]]>" + "</" + TAG_remarks + ">");
        }
        xml.append("</Class>");
        return xml.toString();
    }
}

