/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import pk.com.softech.messages.MarketState;
import pk.com.softech.messages.Message;

public class MarketStateResponse
extends Message {
    private static final long serialVersionUID = 100043L;
    protected MarketState[] rows;
    protected int filled;
    public static final String TAG_filled = "FLD";
    public static final String TAG_rows = "ROW";

    public MarketStateResponse(MarketState[] states) {
        super(0);
        this.filled = 0;
        if (states != null) {
            this.filled = states.length;
            this.rows = new MarketState[states.length];
            System.arraycopy(states, 0, this.rows, 0, states.length);
        }
    }

    public MarketStateResponse(int size) {
        super(0);
        this.rows = new MarketState[size];
        this.filled = 0;
    }

    protected void setMarketStates(MarketState[] states) {
        this.rows = states;
    }

    public void addMarketState(MarketState data) throws ArrayIndexOutOfBoundsException {
        this.rows[this.filled++] = data;
    }

    public MarketState[] getMarketStates() {
        return this.rows;
    }

    @Override
    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"MarketStateResponse\"><FLD>" + this.filled + "</" + TAG_filled + ">");
        int i = 0;
        while (i < this.filled) {
            if (this.rows[i] != null) {
                xml.append("<ROW>" + this.rows[i].toXML() + "</" + TAG_rows + ">");
            }
            ++i;
        }
        xml.append("</Class>");
        return xml.toString();
    }
}

