/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import java.util.Date;
import pk.com.softech.messages.Message;

public class MarketState
extends Message {
    private static final long serialVersionUID = 100041L;
    public static final int LOAD = 0;
    public static final int PRE_OPENING = 1;
    public static final int PRE_OPEN = 2;
    public static final int OPENING = 3;
    public static final int OPEN = 4;
    public static final int PRE_CLOSE = 5;
    public static final int CLOSING = 6;
    public static final int CLOSE = 7;
    public static final int SUSPEND = 8;
    public static final int FLUSH = 9;
    public static final int OPENCLOSE = 10;
    public static final int READY = 11;
    public static final String[] stateNames = new String[]{"LOD", "PRI", "PRE", "OPI", "OPN", "PRC", "CLI", "CLO", "SUS", "FLU", "OPC", "RDY"};
    protected String market;
    protected String description;
    protected int state;
    public static final String TAG_market = "MKT";
    public static final String TAG_description = "DES";
    public static final String TAG_state = "STT";

    public MarketState(String market, int state, String description) {
        super(900);
        this.setMarket(market);
        this.setState(state);
        this.setDescription(description);
    }

    public MarketState() {
        super(900);
    }

    public MarketState(String market, int state, String description, Date time) {
        this(market, state, description);
        this.setTimeStamp(time);
    }

    public void setMarket(String market) {
        this.market = market;
    }

    public void setState(int state) {
        if (state == 0 || state == 1 || state == 2 || state == 3 || state == 4 || state == 5 || state == 6 || state == 7 || state == 8 || state == 10 || state == 11) {
            this.state = state;
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getMarket() {
        return this.market;
    }

    public int getState() {
        return this.state;
    }

    public String getDescription() {
        return this.description;
    }

    public String formatString() {
        return "";
    }

    @Override
    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"MarketState\">");
        if (this.market != null && !this.market.equals("")) {
            xml.append("<MKT><![CDATA[" + this.market + "]]>" + "</" + TAG_market + ">");
        }
        if (this.description != null && !this.description.equals("")) {
            xml.append("<DES><![CDATA[" + this.description + "]]>" + "</" + TAG_description + ">");
        }
        xml.append("<STT>" + this.state + "</" + TAG_state + ">" + "</Class>");
        return xml.toString();
    }
}

