/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import pk.com.softech.messages.MarketData;
import pk.com.softech.messages.Message;

public class MarketResponse
extends Message {
    private static final long serialVersionUID = 100040L;
    MarketData[] rows;
    int filled;
    public static final String TAG_rows = "ROW";
    public static final String TAG_filled = "FLD";

    public MarketResponse(int size) {
        super(402);
        this.rows = new MarketData[size];
        this.filled = 0;
    }

    public MarketResponse(MarketData[] rows) {
        this(rows.length);
        System.arraycopy(rows, 0, this.rows, 0, rows.length);
        this.filled = rows.length;
    }

    public void addmarket(MarketData data) throws ArrayIndexOutOfBoundsException {
        this.rows[this.filled++] = data;
    }

    public MarketData[] getrows() {
        return this.rows;
    }

    public String formatString() {
        return "";
    }

    @Override
    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"MarketResponse\"><FLD>" + this.filled + "</" + TAG_filled + ">");
        int i = 0;
        while (i < this.filled) {
            if (this.rows[i] != null) {
                xml.append("<ROW>" + this.rows[i].toXML() + "</" + TAG_rows + ">");
            }
            ++i;
        }
        xml.append("</Class>");
        return xml.toString();
    }
}

