/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import java.io.Serializable;

public class MarketData
implements Serializable {
    private static final long serialVersionUID = 100038L;
    public static int REGULAR = 0;
    public static int COT = 1;
    public static int ODD_LOT = 2;
    public static int FUTURE = 3;
    public static int ODL = 4;
    public static int PRV = 5;
    public static int CSF = 6;
    public static int SIF = 7;
    public static int NCLCSF = 8;
    public static int NCLDFUT = 9;
    public static int GAXREG = 10;
    public static int GAXODL = 11;
    public static String[] marketNames = new String[]{"REG", "COT", "ODD", "FUT", "ODL", "PRV", "CSF", "SIF", "NCLCSF", "NCLDFUT", "GAX-REG", "GAX-ODL"};
    protected int type;
    protected String code;
    private double upperLimit;
    private double lowerLimit;
    public static final String TAG_type = "TYP";
    public static final String TAG_code = "COD";
    public static final String TAG_upperLimit = "UPL";
    public static final String TAG_lowerLimit = "LOL";

    public MarketData(String code, int type) {
        this.setCode(code);
        this.setType(type);
    }

    public MarketData() {
    }

    public int getType() {
        return this.type;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return marketNames[this.type];
    }

    public static String getName(int type) {
        if (MarketData.verifyType(type)) {
            return marketNames[type];
        }
        throw new IllegalArgumentException("Unidentifiable market type");
    }

    public void setType(int type) {
        if (!MarketData.verifyType(type)) {
            throw new IllegalArgumentException("Unidentifiable market type");
        }
        this.type = type;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setUpperLimit(double upperLimit) {
        this.upperLimit = upperLimit;
    }

    public double getUpperLimit() {
        return this.upperLimit;
    }

    public void setLowerLimit(double lowerLimit) {
        this.lowerLimit = lowerLimit;
    }

    public double getLowerLimit() {
        return this.lowerLimit;
    }

    public static boolean verifyType(int type) {
        return type == REGULAR || type == COT || type == ODD_LOT || type == ODL || type == PRV || type == FUTURE || type == CSF || type == SIF || type == NCLDFUT || type == NCLCSF || type == GAXREG || type == GAXODL;
    }

    public static boolean verifyName(String name) {
        return name.equals(marketNames[REGULAR]) || name.equals(marketNames[COT]) || name.equals(marketNames[ODD_LOT]) || name.equals(marketNames[ODL]) || name.equals(marketNames[PRV]) || name.equals(marketNames[FUTURE]) || name.equals(marketNames[CSF]) || name.equals(marketNames[SIF]) || name.equals(marketNames[NCLDFUT]) || name.equals(marketNames[NCLCSF]) || name.equals(marketNames[GAXREG]) || name.equals(marketNames[GAXODL]);
    }

    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"MarketData\"><TYP>" + this.type + "</" + TAG_type + ">");
        if (this.code != null && !this.code.equals("")) {
            xml.append("<COD><![CDATA[" + this.code + "]]>" + "</" + TAG_code + ">");
        }
        xml.append("<UPL><![CDATA[" + this.getUpperLimit() + "]]>" + "</" + TAG_upperLimit + ">");
        xml.append("<LOL><![CDATA[" + this.getLowerLimit() + "]]>" + "</" + TAG_lowerLimit + ">");
        xml.append("</Class>");
        return xml.toString();
    }
}

