/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import pk.com.softech.messages.MarginData;
import pk.com.softech.messages.Message;

public class MarginResponse
extends Message {
    private static final long serialVersionUID = 100034L;
    private String clientName;
    private String traderName;
    private String traderCode;
    protected int marginType;
    protected float cashBalance;
    protected float cashBlocked;
    protected float cashUnblocked;
    protected float custody;
    protected float availableMargin;
    protected float cot;
    protected float future;
    protected float provisional;
    protected float pendingOrders;
    protected float totalOpen;
    protected float exposureAllowed;
    protected float marginPercentage;
    protected float markTomark;
    protected float futureBlockProfit;
    protected float mtsCfs;
    protected float mfsCfs;
    MarginData[] rows;
    protected int filled;
    protected int responseType;
    public static final String TAG_marginType = "";
    public static final String TAG_cashBalance = "";
    public static final String TAG_cashBlocked = "";
    public static final String TAG_cashUnblocked = "";
    public static final String TAG_custody = "";
    public static final String TAG_availableMargin = "";
    public static final String TAG_cot = "";
    public static final String TAG_future = "";
    public static final String TAG_provisional = "";
    public static final String TAG_pendingOrders = "";
    public static final String TAG_totalOpen = "";
    public static final String TAG_exposureAllowed = "";
    public static final String TAG_marginPercentage = "";
    public static final String TAG_rows = "";
    public static final String TAG_filled = "";

    public MarginResponse(int type, int size, float cashBal, float blocked, float unblocked, float custodyBal, float availMargin, float cotPosition, float futureValue, float provValue, float pendOrders, float openValue, float expAllowed, float marginPercent, float markTomark, int responseType) {
        super(416);
        this.rows = new MarginData[size];
        this.filled = 0;
        this.setMarginType(type);
        this.setCashBalance(cashBal);
        this.setCashBlocked(blocked);
        this.setCashUnblocked(unblocked);
        this.setCustody(custodyBal);
        this.setAvailableMargin(availMargin);
        this.setCOT(cotPosition);
        this.setFuture(futureValue);
        this.setProvisional(provValue);
        this.setPendingOrders(pendOrders);
        this.setTotalOpen(openValue);
        this.setExposureAllowed(expAllowed);
        this.setMarginPercentage(marginPercent);
        this.setMarkTomark(markTomark);
        this.setResponseType(responseType);
    }

    public MarginResponse(int size) {
        super(416);
        this.rows = new MarginData[size];
        this.filled = 0;
    }

    public void set(MarginData[] rws) {
        this.rows = rws;
    }

    public void addMarginData(MarginData data) throws ArrayIndexOutOfBoundsException {
        this.rows[this.filled++] = data;
    }

    public MarginData[] getrows() {
        return this.rows;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getTraderName() {
        return this.traderName;
    }

    public void setTraderName(String traderName) {
        this.traderName = traderName;
    }

    public String getTraderCode() {
        return this.traderCode;
    }

    public void setTraderCode(String traderCode) {
        this.traderCode = traderCode;
    }

    public float getCashBalance() {
        return this.cashBalance;
    }

    public float getCashBlocked() {
        return this.cashBlocked;
    }

    public float getCashUnblocked() {
        return this.cashUnblocked;
    }

    public float getCustody() {
        return this.custody;
    }

    public float getAvailableMargin() {
        return this.availableMargin;
    }

    public float getCOT() {
        return this.cot;
    }

    public float getMtsCfs() {
        return this.mtsCfs;
    }

    public void setMtsCfs(float mtsCFS) {
        this.mtsCfs = mtsCFS;
    }

    public float getMfsCfs() {
        return this.mfsCfs;
    }

    public void setMfsCfs(float mfsCfs) {
        this.mfsCfs = mfsCfs;
    }

    public float getFuture() {
        return this.future;
    }

    public float getProvisional() {
        return this.provisional;
    }

    public float getPendingOrders() {
        return this.pendingOrders;
    }

    public float getTotalOpen() {
        return this.totalOpen;
    }

    public float getExposureAllowed() {
        return this.exposureAllowed;
    }

    public float getMarginPercentage() {
        return this.marginPercentage;
    }

    public float getMarkTomark() {
        return this.markTomark;
    }

    public void setCashBalance(float cashBal) {
        this.cashBalance = cashBal;
    }

    public void setCashBlocked(float blocked) {
        this.cashBlocked = blocked;
    }

    public void setCashUnblocked(float unblocked) {
        this.cashUnblocked = unblocked;
    }

    public void setCustody(float custodyBal) {
        this.custody = custodyBal;
    }

    public float getFutureBlockProfit() {
        return this.futureBlockProfit;
    }

    public void setFutureBlockProfit(float futureBlockProfit) {
        this.futureBlockProfit = futureBlockProfit;
    }

    public void setAvailableMargin(float availMargin) {
        this.availableMargin = availMargin;
    }

    public void setCOT(float cotPosition) {
        this.cot = cotPosition;
    }

    public void setFuture(float futureValue) {
        this.future = futureValue;
    }

    public void setProvisional(float provValue) {
        this.provisional = provValue;
    }

    public void setPendingOrders(float pendOrders) {
        this.pendingOrders = pendOrders;
    }

    public void setTotalOpen(float openValue) {
        this.totalOpen = openValue;
    }

    public void setExposureAllowed(float expAllowed) {
        this.exposureAllowed = expAllowed;
    }

    public void setMarginPercentage(float marginPercent) {
        this.marginPercentage = marginPercent;
    }

    public void setMarkTomark(float mtm) {
        this.markTomark = mtm;
    }

    public void setMarginType(int type) {
        switch (type) {
            case 0: 
            case 1: {
                this.marginType = type;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Margin Type.");
            }
        }
    }

    public int getMarginType() {
        return this.marginType;
    }

    public void setResponseType(int responseType) {
        this.responseType = responseType;
    }

    public int getResponseType() {
        return this.responseType;
    }

    public String formatString() {
        return "";
    }

    @Override
    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"MarginResponse\"><>" + this.filled + "</" + ">" + "<" + ">" + this.marginType + "</" + ">" + "<" + ">" + this.cashBalance + "</" + ">" + "<" + ">" + this.cashBlocked + "</" + ">" + "<" + ">" + this.cashUnblocked + "</" + ">" + "<" + ">" + this.custody + "</" + ">" + "<" + ">" + this.availableMargin + "</" + ">" + "<" + ">" + this.cot + "</" + ">" + "<" + ">" + this.future + "</" + ">" + "<" + ">" + this.provisional + "</" + ">" + "<" + ">" + this.pendingOrders + "</" + ">" + "<" + ">" + this.totalOpen + "</" + ">" + "<" + ">" + this.exposureAllowed + "</" + ">" + "<" + ">" + this.marginPercentage + "</" + ">");
        int i = 0;
        while (i < this.filled) {
            if (this.rows[i] != null) {
                xml.append("<>" + this.rows[i].toXML() + "</" + ">");
            }
            ++i;
        }
        xml.append("</Class>");
        return xml.toString();
    }
}

