/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import pk.com.softech.messages.Message;

public class MarginRequest
extends Message {
    private static final long serialVersionUID = 100033L;
    public static final int ORIGINAL = 0;
    public static final int FRIENDLY = 1;
    public static final int CASH_BASE = 0;
    public static final int DETAILED = 1;
    protected String client;
    protected int marginType;
    protected int requestType;
    public static final String TAG_client = "CLI";
    public static final String TAG_marginType = "MTY";

    public MarginRequest(int reportType, String clientCode, int requestType) {
        super(316);
        this.setMarginType(reportType);
        this.setClient(clientCode);
        this.setRequestType(requestType);
    }

    public MarginRequest() {
        super(316);
    }

    public void setClient(String clientCode) {
        this.client = clientCode;
    }

    public String getClient() {
        return this.client;
    }

    public void setMarginType(int displayType) {
        switch (displayType) {
            case 0: 
            case 1: {
                this.marginType = displayType;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Margin report type.");
            }
        }
    }

    public int getMarginType() {
        return this.marginType;
    }

    public int getRequestType() {
        return this.requestType;
    }

    public void setRequestType(int requestType) {
        this.requestType = requestType;
    }

    @Override
    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"MarginRequest\">");
        if (this.client != null && !this.client.equals("")) {
            xml.append("<CLI><![CDATA[" + this.client + "]]>" + "</" + TAG_client + ">");
        }
        xml.append("<MTY>" + this.marginType + "</" + TAG_marginType + ">" + "</Class>");
        return xml.toString();
    }
}

