/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MarginNotificationsData
implements Serializable {
    private static final long serialVersionUID = 100030L;
    private String client = null;
    private String clientName = null;
    private String clientEmail = null;
    private float currentMargin = 0.0f;
    private float lastCallMargin = 0.0f;
    private float marginPercentage = 0.0f;
    private float lastCallCash = 0.0f;
    private Date lastCallTime = null;
    private int callsSent = 0;
    private float shortAmount = 0.0f;
    private String clientEmail2 = "";
    private String stExCode = "";
    private String clientBranch = "";
    private String traderName = "";
    public static final String TAG_client = "CLI";
    public static final String TAG_clientEmail = "CEM";
    public static final String TAG_callPercentage = "CPR";
    public static final String TAG_currentMargin = "CMR";
    public static final String TAG_lastCallMargin = "LMR";
    public static final String TAG_lastCallTime = "LCT";
    public static final String TAG_callsSent = "CST";
    public static final String TAG_shortAmount = "SAM";

    public MarginNotificationsData(String cl, String clientName, String email, float currentMargin, float lastMargin, float lastCash, Date lastTime, int callsSent, float shortAmt, String email2, String stExCode, float marginPercentage, String branchName, String traderName) {
        this.setClient(cl);
        this.setClientName(clientName);
        this.setClientEmail(email);
        this.setCurrentMargin(currentMargin);
        this.setLastCallMargin(lastMargin);
        this.setLastCallCash(lastCash);
        this.setLastCallTime(lastTime);
        this.setCallsSent(callsSent);
        this.setShortAmount(shortAmt);
        this.setClientEmail2(email2);
        this.setStExCode(stExCode);
        this.setMarginPercentage(marginPercentage);
        this.setClientBranch(branchName);
        this.setTraderName(traderName);
    }

    public MarginNotificationsData() {
    }

    public void setClient(String cl) {
        this.client = cl;
    }

    public void setClientEmail(String email) {
        this.clientEmail = email;
    }

    public void setCurrentMargin(float margin) {
        this.currentMargin = margin;
    }

    public void setLastCallCash(float lastCash) {
        this.lastCallCash = lastCash;
    }

    public void setLastCallMargin(float margin) {
        this.lastCallMargin = margin;
    }

    public void setLastCallTime(Date time) {
        this.lastCallTime = time;
    }

    public void setCallsSent(int calls) {
        this.callsSent = calls;
    }

    public void setShortAmount(float shortAmt) {
        this.shortAmount = shortAmt;
    }

    public void setClientEmail2(String email2) {
        this.clientEmail2 = email2;
    }

    public String getClient() {
        return this.client;
    }

    public String getClientEmail() {
        return this.clientEmail;
    }

    public float getCurrentMargin() {
        return this.currentMargin;
    }

    public float getLastCallMargin() {
        return this.lastCallMargin;
    }

    public float getLastCallCash() {
        return this.lastCallCash;
    }

    public Date getLastCallTime() {
        return this.lastCallTime;
    }

    public int getCallsSent() {
        return this.callsSent;
    }

    public float getShortAmt() {
        return this.shortAmount;
    }

    public String getClientEmail2() {
        return this.clientEmail2;
    }

    public String getStExCode() {
        return this.stExCode;
    }

    public void setStExCode(String stExCode) {
        this.stExCode = stExCode;
    }

    public float getMarginPercentage() {
        return this.marginPercentage;
    }

    public void setMarginPercentage(float marginPercentage) {
        this.marginPercentage = marginPercentage;
    }

    public String getClientBranch() {
        return this.clientBranch;
    }

    public void setClientBranch(String clientBranch) {
        this.clientBranch = clientBranch;
    }

    public String getTraderName() {
        return this.traderName;
    }

    public void setTraderName(String tradeName) {
        this.traderName = tradeName;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String toXML() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        dateFormat.setLenient(false);
        StringBuffer xml = new StringBuffer("<Class name=\"MarginNotificationsData\">");
        if (this.client != null && !this.client.equals("")) {
            xml.append("<CLI><![CDATA[" + this.client + "]]>" + "</" + TAG_client + ">");
        }
        if (this.clientEmail != null && !this.clientEmail.equals("")) {
            xml.append("<CEM><![CDATA[" + this.clientEmail + "]]>" + "</" + TAG_clientEmail + ">");
        }
        xml.append("<CMR>" + this.currentMargin + "</" + TAG_currentMargin + ">" + "<" + TAG_lastCallMargin + ">" + this.lastCallMargin + "</" + TAG_lastCallMargin + ">" + "<" + TAG_lastCallTime + ">" + dateFormat.format(this.lastCallTime) + "</" + TAG_lastCallTime + ">" + "<" + TAG_callsSent + ">" + this.callsSent + "</" + TAG_callsSent + ">" + "<" + TAG_shortAmount + ">" + this.shortAmount + "</" + TAG_shortAmount + ">" + "</Class>");
        return xml.toString();
    }
}

