/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import java.io.Serializable;

public class MarginData
implements Serializable {
    private static final long serialVersionUID = 100029L;
    private String symbol;
    private int unbilledBalance;
    private int billedBalance;
    private int todayReceivedDelivery;
    private int pendingOrdersBalance;
    private int futureBalance;
    private int provisionalBalance;
    private int blockedBalance;
    private int availableBalance;
    private float closeRate;
    private float value;
    private int mtm;
    private int realMtm;
    private int bankPledgeShares;
    private float mtsCFS;
    public static final String TAG_symbol = "SYM";
    public static final String TAG_unbilledBalance = "UBB";
    public static final String TAG_billedBalance = "BLB";
    public static final String TAG_todayReceivedDelivery = "TRD";
    public static final String TAG_pendingOrdersBalance = "POB";
    public static final String TAG_futureBalance = "FUB";
    public static final String TAG_provisionalBalance = "PRB";
    public static final String TAG_blockedBalance = "BKB";
    public static final String TAG_availableBalance = "AVB";
    public static final String TAG_closeRate = "CLR";
    public static final String TAG_value = "VAL";
    public static final String TAG_mtm = "MTM";

    public MarginData(String sym, int unbilled, int billed, int todayRecDev, int pendingOrders, int future, int provisional, int blocked, int available, float closing) {
        this(sym, unbilled, billed, todayRecDev, pendingOrders, future, provisional, blocked, available, closing, 0);
    }

    public MarginData(String sym, int unbilled, int billed, int todayRecDev, int pendingOrders, int future, int provisional, int blocked, int available, float closing, int mtm) {
        this.setSymbol(sym);
        this.setUnbilledBalance(unbilled);
        this.setBilledBalance(billed);
        this.setTodayReceivedDelivery(todayRecDev);
        this.setPendingOrdersBalance(pendingOrders);
        this.setFutureBalance(future);
        this.setProvisionalBalance(provisional);
        this.setBlockedBalance(blocked);
        this.setAvailableBalance(available);
        this.setCloseRate(closing);
        this.setMarkToMarket(mtm);
    }

    public MarginData(String sym, int unbilled, int billed, int todayRecDev, int pendingOrders, int future, int provisional, int blocked, int available, float closing, int mtm, int realMtm) {
        this.setSymbol(sym);
        this.setUnbilledBalance(unbilled);
        this.setBilledBalance(billed);
        this.setTodayReceivedDelivery(todayRecDev);
        this.setPendingOrdersBalance(pendingOrders);
        this.setFutureBalance(future);
        this.setProvisionalBalance(provisional);
        this.setBlockedBalance(blocked);
        this.setAvailableBalance(available);
        this.setCloseRate(closing);
        this.setMarkToMarket(mtm);
        this.setRealMtm(realMtm);
    }

    public MarginData() {
    }

    public void setSymbol(String sym) {
        this.symbol = sym;
    }

    public void setUnbilledBalance(int unbilled) {
        this.unbilledBalance = unbilled;
    }

    public void setBilledBalance(int billed) {
        this.billedBalance = billed;
    }

    public void setTodayReceivedDelivery(int todayRecDev) {
        this.todayReceivedDelivery = todayRecDev;
    }

    public void setPendingOrdersBalance(int pendingOrders) {
        this.pendingOrdersBalance = pendingOrders;
    }

    public void setFutureBalance(int future) {
        this.futureBalance = future;
    }

    public void setProvisionalBalance(int provisional) {
        this.provisionalBalance = provisional;
    }

    public void setBlockedBalance(int blocked) {
        this.blockedBalance = blocked;
    }

    public void setAvailableBalance(int available) {
        this.availableBalance = available;
    }

    public void setCloseRate(float closing) {
        this.closeRate = closing;
    }

    public void setValue(float val) {
        this.value = val;
    }

    public void setMarkToMarket(int markToMarket) {
        this.mtm = markToMarket;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public int getUnbilledBalance() {
        return this.unbilledBalance;
    }

    public int getBilledBalance() {
        return this.billedBalance;
    }

    public int getTodayReceivedDelivery() {
        return this.todayReceivedDelivery;
    }

    public int getPendingOrdersBalance() {
        return this.pendingOrdersBalance;
    }

    public int getFutureBalance() {
        return this.futureBalance;
    }

    public int getProvisionalBalance() {
        return this.provisionalBalance;
    }

    public int getBlockedBalance() {
        return this.blockedBalance;
    }

    public int getAvailableBalance() {
        return this.availableBalance;
    }

    public float getCloseRate() {
        return this.closeRate;
    }

    public float getValue() {
        return this.value;
    }

    public int getMarkToMarket() {
        return this.mtm;
    }

    public int getBankPledgeShares() {
        return this.bankPledgeShares;
    }

    public void setBankPledgeShares(int bankPledgeShares) {
        this.bankPledgeShares = bankPledgeShares;
    }

    public float getMtsCFS() {
        return this.mtsCFS;
    }

    public void setMtsCFS(float mtsCFS) {
        this.mtsCFS = mtsCFS;
    }

    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"MarginData\">");
        if (this.symbol != null && !this.symbol.equals("")) {
            xml.append("<SYM><![CDATA[" + this.symbol + "]]>" + "</" + TAG_symbol + ">");
        }
        xml.append("<UBB>" + this.unbilledBalance + "</" + TAG_unbilledBalance + ">" + "<" + TAG_billedBalance + ">" + this.billedBalance + "</" + TAG_billedBalance + ">" + "<" + TAG_todayReceivedDelivery + ">" + this.todayReceivedDelivery + "</" + TAG_todayReceivedDelivery + ">" + "<" + TAG_pendingOrdersBalance + ">" + this.pendingOrdersBalance + "</" + TAG_pendingOrdersBalance + ">" + "<" + TAG_futureBalance + ">" + this.futureBalance + "</" + TAG_futureBalance + ">" + "<" + TAG_provisionalBalance + ">" + this.provisionalBalance + "</" + TAG_provisionalBalance + ">" + "<" + TAG_blockedBalance + ">" + this.blockedBalance + "</" + TAG_blockedBalance + ">" + "<" + TAG_availableBalance + ">" + this.availableBalance + "</" + TAG_availableBalance + ">" + "<" + TAG_closeRate + ">" + this.closeRate + "</" + TAG_closeRate + ">" + "<" + TAG_value + ">" + this.value + "</" + TAG_value + ">" + "<" + TAG_mtm + ">" + this.mtm + "</" + TAG_mtm + ">" + "</Class>");
        return xml.toString();
    }

    public int getRealMtm() {
        return this.realMtm;
    }

    public void setRealMtm(int realMtm) {
        this.realMtm = realMtm;
    }
}

