/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import pk.com.softech.messages.ManualTradesData;
import pk.com.softech.messages.Message;

public class ManualTradesResponse
extends Message {
    private static final long serialVersionUID = 100131L;
    public static final int INSERT_TRADES_RESPONSE = 1;
    public static final int MANUAL_TRADES_RESPONSE = 2;
    public static final int DELETE_TRADES_RESPONSE = 3;
    public static final int NET_OFF_TRADES_RESPONSE = 4;
    public static final String TAG_rows = "ROW";
    public static final String TAG_filled = "FLD";
    private int responseType;
    ManualTradesData[] rows;
    int filled;

    public ManualTradesResponse(int size) {
        super(430);
        this.rows = new ManualTradesData[size];
        this.filled = 0;
    }

    public ManualTradesResponse(int type, ManualTradesData[] rws) {
        super(430);
        this.filled = 0;
        this.setResponseType(type);
        if (rws != null) {
            this.rows = new ManualTradesData[rws.length];
            this.filled = rws.length;
            System.arraycopy(rws, 0, this.rows, 0, rws.length);
        }
    }

    public void addManualTrades(ManualTradesData data) throws ArrayIndexOutOfBoundsException {
        this.rows[this.filled++] = data;
    }

    public ManualTradesData[] getRows() {
        return this.rows;
    }

    public int getFilled() {
        return this.filled;
    }

    public int getResponseType() {
        return this.responseType;
    }

    public void setResponseType(int responseType) {
        this.responseType = responseType;
    }

    public String formatString() {
        return "";
    }

    @Override
    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"ManualTradesResponse\"><FLD>" + this.filled + "</" + TAG_filled + ">");
        int i = 0;
        while (i < this.filled) {
            if (this.rows[i] != null) {
                xml.append("<ROW>" + this.rows[i].toXML() + "</" + TAG_rows + ">");
            }
            ++i;
        }
        xml.append("</Class>");
        return xml.toString();
    }
}

