/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import java.util.StringTokenizer;
import pk.com.softech.messages.MBPData;
import pk.com.softech.messages.Message;

public class MBP
extends Message {
    private static final long serialVersionUID = 100103L;
    protected String exchange;
    protected String symbol;
    protected String marketType;
    protected String mbpMessage;
    protected MBPData[] buyQueue;
    protected MBPData[] sellQueue;
    protected int buyFilled;
    protected int sellFilled;
    private static final String REGULAR_MARKET_CODE = "REG";
    private static final String FUTURE_MARKET_CODE = "FUT";
    private static final String PROVISIONAL_MARKET_CODE = "IPO";
    private static final String STOCK_INDEX_FUTURE_MARKET_CODE = "SIF";
    public static final String TAG_buyQueue = "BQU";
    public static final String TAG_sellQueue = "SQU";
    public static final String TAG_mbpMessage = "MSG";
    public static final String TAG_exchange = "EXC";
    public static final String TAG_symbol = "SYM";
    public static final String TAG_marketType = "MTY";
    public static final String TAG_buyQueueLength = "BQL";
    public static final String TAG_sellQueueLength = "SQL";

    public MBP(String exchange, String symbol, String marketType, MBPData[] buyQueue, MBPData[] sellQueue) {
        super(0);
        this.setExchange(exchange);
        this.setSymbol(symbol);
        this.setMarketType(marketType);
        this.setBuyQueue(buyQueue);
        this.buyFilled = buyQueue.length;
        this.setSellQueue(sellQueue);
        this.sellFilled = sellQueue.length;
    }

    public MBP(String exchange, String msg) {
        super(0);
        this.buyFilled = 0;
        this.sellFilled = 0;
        this.setMBPMessage(msg);
        String[] allTokens = this.getTokens(msg, "|");
        String[] buySellTokens = this.getTokens(allTokens[1], ";");
        this.setExchange(exchange);
        this.setSymbol(buySellTokens[0]);
        this.setMarketType(buySellTokens[1]);
        String[] buyTokens = null;
        String[] sellTokens = null;
        if (!buySellTokens[3].equals("SELL")) {
            String buyMsg = buySellTokens[3];
            buyTokens = this.getTokens(buyMsg, "$");
            if (buySellTokens.length >= 6) {
                String sellMsg = buySellTokens[5];
                sellTokens = this.getTokens(sellMsg, "$");
            }
        } else if (buySellTokens.length >= 5) {
            String sellMsg = buySellTokens[4];
            sellTokens = this.getTokens(sellMsg, "$");
        }
        String[] valueTokens = null;
        if (buyTokens != null) {
            this.buyQueue = new MBPData[buyTokens.length];
            this.buyFilled = buyTokens.length;
            int i = 0;
            while (i < buyTokens.length) {
                valueTokens = this.getTokens(buyTokens[i], ",");
                this.buyQueue[i] = new MBPData(Integer.parseInt(valueTokens[0]), Integer.parseInt(valueTokens[1]), Float.parseFloat(valueTokens[2]));
                ++i;
            }
        }
        if (sellTokens != null) {
            this.sellQueue = new MBPData[sellTokens.length];
            this.sellFilled = sellTokens.length;
            int i = 0;
            while (i < sellTokens.length) {
                valueTokens = this.getTokens(sellTokens[i], ",");
                this.sellQueue[i] = new MBPData(Integer.parseInt(valueTokens[0]), Integer.parseInt(valueTokens[1]), Float.parseFloat(valueTokens[2]));
                ++i;
            }
        }
    }

    public MBP(String msg) {
        super(0);
        this.buyFilled = 0;
        this.sellFilled = 0;
        this.setMBPMessage(msg);
        String[] allTokens = this.getTokens(msg, "|");
        String[] buySellTokens = this.getTokens(allTokens[1], ";");
        this.setExchange(buySellTokens[0]);
        this.setSymbol(buySellTokens[1]);
        this.setMarketType(buySellTokens[2]);
        String[] buyTokens = null;
        String[] sellTokens = null;
        if (!buySellTokens[4].equals("SELL")) {
            String buyMsg = buySellTokens[4];
            buyTokens = this.getTokens(buyMsg, "$");
            if (buySellTokens.length >= 7) {
                String sellMsg = buySellTokens[6];
                sellTokens = this.getTokens(sellMsg, "$");
            }
        } else if (buySellTokens.length >= 6) {
            String sellMsg = buySellTokens[5];
            sellTokens = this.getTokens(sellMsg, "$");
        }
        String[] valueTokens = null;
        if (buyTokens != null) {
            this.buyQueue = new MBPData[buyTokens.length];
            this.buyFilled = buyTokens.length;
            int i = 0;
            while (i < buyTokens.length) {
                valueTokens = this.getTokens(buyTokens[i], ",");
                this.buyQueue[i] = new MBPData(Integer.parseInt(valueTokens[0]), Integer.parseInt(valueTokens[1]), Float.parseFloat(valueTokens[2]));
                ++i;
            }
        }
        if (sellTokens != null) {
            this.sellQueue = new MBPData[sellTokens.length];
            this.sellFilled = sellTokens.length;
            int i = 0;
            while (i < sellTokens.length) {
                valueTokens = this.getTokens(sellTokens[i], ",");
                this.sellQueue[i] = new MBPData(Integer.parseInt(valueTokens[0]), Integer.parseInt(valueTokens[1]), Float.parseFloat(valueTokens[2]));
                ++i;
            }
        }
    }

    public MBP(int buy, int sell) {
        super(0);
        this.buyFilled = 0;
        this.sellFilled = 0;
        this.buyQueue = new MBPData[buy];
        this.sellQueue = new MBPData[sell];
    }

    public void setExchange(String exchange) {
        this.exchange = exchange;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public void setMarketType(String marketType) {
        this.marketType = marketType.equals(REGULAR_MARKET_CODE) || marketType.equals(PROVISIONAL_MARKET_CODE) || marketType.equals(STOCK_INDEX_FUTURE_MARKET_CODE) ? REGULAR_MARKET_CODE : marketType;
    }

    public void addBuyRow(MBPData buyRow) throws ArrayIndexOutOfBoundsException {
        this.buyQueue[this.buyFilled++] = buyRow;
    }

    public void addSellRow(MBPData sellRow) throws ArrayIndexOutOfBoundsException {
        this.sellQueue[this.sellFilled++] = sellRow;
    }

    protected void setBuyQueue(MBPData[] buyQueue) {
        this.buyQueue = buyQueue;
    }

    protected void setSellQueue(MBPData[] sellQueue) {
        this.sellQueue = sellQueue;
    }

    public String getExchange() {
        return this.exchange;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getMarketType() {
        return this.marketType;
    }

    public MBPData[] getBuyQueue() {
        return this.buyQueue;
    }

    public MBPData[] getSellQueue() {
        return this.sellQueue;
    }

    public int getBuyFilled() {
        return this.buyFilled;
    }

    public int getSellFilled() {
        return this.sellFilled;
    }

    public void setMBPMessage(String mbpMessage) {
        this.mbpMessage = mbpMessage;
    }

    public String formatString() {
        StringBuffer buffer = new StringBuffer("MBP");
        buffer.append("|");
        buffer.append(this.getExchange());
        buffer.append(";");
        buffer.append(this.getSymbol());
        buffer.append(";");
        buffer.append(this.getMarketType());
        buffer.append(";");
        buffer.append("BUY");
        buffer.append(";");
        int i = 0;
        while (i < this.buyFilled) {
            if (this.buyQueue[i].getPrice() != 0.0f || this.buyQueue[i].getVolume() != 0 || this.buyQueue[i].getOrders() != 0) {
                buffer.append(this.buyQueue[i].getOrders());
                buffer.append(",");
                buffer.append(this.buyQueue[i].getVolume());
                buffer.append(",");
                buffer.append(this.buyQueue[i].getPrice());
                buffer.append("$");
            }
            ++i;
        }
        buffer.append(";");
        buffer.append("SELL");
        buffer.append(";");
        i = 0;
        while (i < this.sellFilled) {
            if (this.sellQueue[i].getPrice() != 0.0f || this.sellQueue[i].getVolume() != 0 || this.sellQueue[i].getOrders() != 0) {
                buffer.append(this.sellQueue[i].getOrders());
                buffer.append(",");
                buffer.append(this.sellQueue[i].getVolume());
                buffer.append(",");
                buffer.append(this.sellQueue[i].getPrice());
                buffer.append("$");
            }
            ++i;
        }
        buffer.append(";");
        buffer.append("|");
        return buffer.toString();
    }

    public String formatEmptyString() {
        StringBuffer buffer = new StringBuffer("MBP");
        buffer.append("|");
        buffer.append(this.getExchange());
        buffer.append(";");
        buffer.append(this.getSymbol());
        buffer.append(";");
        buffer.append(this.getMarketType());
        buffer.append(";");
        buffer.append("BUY");
        buffer.append(";");
        buffer.append(";");
        buffer.append("SELL");
        buffer.append(";");
        buffer.append(";");
        buffer.append("|");
        return buffer.toString();
    }

    private String[] getTokens(String str, String delimiter) {
        String[] tokenArray = null;
        StringTokenizer st = new StringTokenizer(str, delimiter);
        int tokenCount = st.countTokens();
        tokenArray = new String[tokenCount];
        int i = 0;
        while (i < tokenCount) {
            tokenArray[i] = st.nextToken();
            ++i;
        }
        return tokenArray;
    }

    @Override
    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"MBP\"><BQL>" + this.buyFilled + "</" + TAG_buyQueueLength + ">" + "<" + TAG_sellQueueLength + ">" + this.sellFilled + "</" + TAG_sellQueueLength + ">");
        if (this.exchange != null && !this.exchange.equals("")) {
            xml.append("<EXC><![CDATA[" + this.exchange + "]]>" + "</" + TAG_exchange + ">");
        }
        if (this.symbol != null && !this.symbol.equals("")) {
            xml.append("<SYM><![CDATA[" + this.symbol + "]]>" + "</" + TAG_symbol + ">");
        }
        if (this.marketType != null && !this.marketType.equals("")) {
            xml.append("<MTY><![CDATA[" + this.marketType + "]]>" + "</" + TAG_marketType + ">");
        }
        if (this.mbpMessage != null && !this.mbpMessage.equals("")) {
            xml.append("<MSG><![CDATA[" + this.mbpMessage + "]]>" + "</" + TAG_mbpMessage + ">");
        }
        int i = 0;
        while (i < this.buyFilled) {
            if (this.buyQueue[i] != null) {
                xml.append("<BQU>" + this.buyQueue[i].toXML() + "</" + TAG_buyQueue + ">");
            }
            ++i;
        }
        i = 0;
        while (i < this.sellFilled) {
            if (this.sellQueue[i] != null) {
                xml.append("<SQU>" + this.sellQueue[i].toXML() + "</" + TAG_sellQueue + ">");
            }
            ++i;
        }
        xml.append("</Class>");
        return xml.toString();
    }
}

