/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import pk.com.softech.messages.Message;

public class LoginMessage
extends Message {
    private static final long serialVersionUID = 100027L;
    protected String userId;
    protected String password;
    protected String key;
    protected int feedPort;
    protected int invLoginTries;
    private boolean updateFlag;
    private String eclipseVersion;
    private int terminalType = OTHERS;
    public static int ECLIPSE_TERMINAL = 0;
    public static int OLD_TERMINAL = 1;
    public static int OTHERS = 2;
    public static int MOBILE = 3;
    public static final String TAG_userId = "UID";
    public static final String TAG_password = "PWD";
    public static final String TAG_key = "KEY";
    public static final String TAG_feedPort = "FPR";
    public static final String TAG_invLoginTries = "ILT";
    public static final String TAG_terminalType = "TTP";

    public LoginMessage(String userId, String password, String key, int port, boolean updateFlag, int terminalType) {
        this(userId, password, key, port, 0, updateFlag, terminalType);
    }

    public LoginMessage(String userId, String password, String key, int port, boolean updateFlag) {
        this(userId, password, key, port, 0, updateFlag, OTHERS);
    }

    public LoginMessage(String userId, String password, String key, int port, boolean updateFlag, int terminalType, String eclipseVersion) {
        this(userId, password, key, port, 0, updateFlag, terminalType);
        this.setEclipseVersion(eclipseVersion);
    }

    public LoginMessage(String userId, String password, String key, int port, int invLogTries, boolean updateFlag, int terminalType) {
        super(1);
        this.setUserId(userId);
        this.setPassword(password);
        this.setPort(port);
        this.setKey(key);
        this.setInvLoginTries(invLogTries);
        this.setUpdateFlag(updateFlag);
        this.setTerminalType(terminalType);
    }

    public LoginMessage() {
        super(1);
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPort(int port) {
        this.feedPort = port;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setInvLoginTries(int invLogTries) {
        this.invLoginTries = invLogTries;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPort() {
        return this.feedPort;
    }

    public String getKey() {
        return this.key;
    }

    public int getInvLoginTries() {
        return this.invLoginTries;
    }

    public void setUpdateFlag(boolean updateFlag) {
        this.updateFlag = updateFlag;
    }

    public boolean isUpdateFlag() {
        return this.updateFlag;
    }

    public void setTerminalType(int terminalType) {
        this.terminalType = terminalType;
    }

    public int getTerminalType() {
        return this.terminalType;
    }

    public void setEclipseVersion(String eclipseVersion) {
        this.eclipseVersion = eclipseVersion;
    }

    public String getEclipseVersion() {
        return this.eclipseVersion;
    }

    public String formatString() {
        return "LI|" + this.getUserId() + "|" + this.getPassword() + "|" + this.getPort() + "|" + this.getKey() + "|" + this.getInvLoginTries();
    }

    @Override
    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"LoginMessage\">");
        if (this.userId != null && !this.userId.equals("")) {
            xml.append("<UID><![CDATA[" + this.userId + "]]>" + "</" + TAG_userId + ">");
        }
        if (this.password != null && !this.password.equals("")) {
            xml.append("<PWD><![CDATA[" + this.password + "]]>" + "</" + TAG_password + ">");
        }
        if (this.key != null && !this.key.equals("")) {
            xml.append("<KEY><![CDATA[" + this.key + "]]>" + "</" + TAG_key + ">");
        }
        xml.append("<FPR>" + this.feedPort + "</" + TAG_feedPort + ">" + "<" + TAG_invLoginTries + ">" + this.invLoginTries + "</" + TAG_invLoginTries + ">" + "<" + TAG_terminalType + ">" + this.terminalType + "</" + TAG_terminalType + ">" + "</Class>");
        return xml.toString();
    }
}

