/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import java.io.Serializable;
import java.util.Date;

public class LockedSymbolData
implements Serializable {
    private static final long serialVersionUID = 100181L;
    protected String lockedSymbol;
    protected String market;
    protected String exchange;
    protected long buyVolume;
    protected long sellVolume;
    protected String symbolChange;
    private String lastPrice;
    private Date LTrdTime;
    public static final String TAG_lockedSymbol = "TLS";
    public static final String TAG_symbolChange = "TSC";
    public static final String TAG_lastPrice = "LPR";
    public static final String TAG_tradeTime = "TTM";

    public LockedSymbolData(String lockedSymbol, String market, String exchange, long buyVolume, long sellVolume, String symbolChange, String lastPrice, Date trdTime) {
        this.setLockedSymbol(lockedSymbol);
        this.setSymbolChange(symbolChange);
        this.setMarket(market);
        this.setExchange(exchange);
        this.setLastPrice(lastPrice);
        this.setLTrdTime(trdTime);
        this.setBuyVolume(buyVolume);
        this.setSellVolume(sellVolume);
    }

    public LockedSymbolData() {
    }

    public String getLockedSymbol() {
        return this.lockedSymbol;
    }

    public String getSymbolChange() {
        return this.symbolChange;
    }

    public void setLockedSymbol(String lockedSymbol) {
        this.lockedSymbol = lockedSymbol;
    }

    public long getBuyVolume() {
        return this.buyVolume;
    }

    public void setBuyVolume(long volume) {
        this.buyVolume = volume;
    }

    public long getSellVolume() {
        return this.sellVolume;
    }

    public void setSellVolume(long volume) {
        this.sellVolume = volume;
    }

    public void setSymbolChange(String symbolChange) {
        this.symbolChange = symbolChange;
    }

    public String getLastPrice() {
        return this.lastPrice;
    }

    public void setLastPrice(String lastPrice) {
        this.lastPrice = lastPrice;
    }

    public Date getLTrdTime() {
        return this.LTrdTime;
    }

    public void setLTrdTime(Date trdTime) {
        this.LTrdTime = trdTime;
    }

    public String getMarket() {
        return this.market;
    }

    public void setMarket(String market) {
        this.market = market;
    }

    public String getExchange() {
        return this.exchange;
    }

    public void setExchange(String exchange) {
        this.exchange = exchange;
    }

    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"ClearingTypeData\">");
        if (this.lockedSymbol != null && !this.lockedSymbol.equals("")) {
            xml.append("<TLS><![CDATA[" + this.lockedSymbol + "]]>" + "</" + TAG_lockedSymbol + ">");
        }
        if (this.symbolChange != null && !this.symbolChange.equals("")) {
            xml.append("<TSC><![CDATA[" + this.symbolChange + "]]>" + "</" + TAG_symbolChange + ">");
        }
        xml.append("<LPR><![CDATA[" + this.lastPrice + "]]>" + "</" + TAG_lastPrice + ">");
        xml.append("<TTM><![CDATA[" + this.LTrdTime + "]]>" + "</" + TAG_tradeTime + ">");
        xml.append("</Class>");
        return xml.toString();
    }
}

