/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import pk.com.softech.messages.GraphData;
import pk.com.softech.messages.Message;

public class IndexGraphResponse
extends Message {
    private static final long serialVersionUID = 100025L;
    public static final int HISTORY = 0;
    public static final int INTRADAY = 1;
    GraphData[] rows;
    int filled;
    private int chartType;
    private String indexName;
    public static final String TAG_rows = "ROW";
    public static final String TAG_filled = "FLD";

    public IndexGraphResponse(int size) {
        super(412);
        this.rows = new GraphData[size];
        this.filled = 0;
        this.setChartType(1);
    }

    public IndexGraphResponse(GraphData[] rws, String indexName, int chartType) {
        super(412);
        this.filled = 0;
        if (rws != null) {
            this.rows = new GraphData[rws.length];
            this.filled = rws.length;
            System.arraycopy(rws, 0, this.rows, 0, rws.length);
        }
        this.setIndexName(indexName);
        this.setChartType(chartType);
    }

    public void addSymbolGraph(GraphData data) throws ArrayIndexOutOfBoundsException {
        this.rows[this.filled++] = data;
    }

    public GraphData[] getrows() {
        return this.rows;
    }

    public String formatString() {
        return "";
    }

    public void setChartType(int chartType) {
        this.chartType = chartType;
    }

    public int getChartType() {
        return this.chartType;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public String toXML() {
        this.setCompress(true);
        StringBuffer xml = new StringBuffer("<Class name=\"IndexGraphResponse\"><FLD>" + this.filled + "</" + TAG_filled + ">");
        int i = 0;
        while (i < this.filled) {
            if (this.rows[i] != null) {
                xml.append("<ROW>" + this.rows[i].toXML() + "</" + TAG_rows + ">");
            }
            ++i;
        }
        xml.append("</Class>");
        return xml.toString();
    }
}

