/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import pk.com.softech.messages.Feed;
import pk.com.softech.util.Utility;

public class INAV
extends Feed {
    private static final long serialVersionUID = 100103L;
    private String exchange;
    private String eftCode;
    private long volume;
    private float lastTradePrice;
    private float inav = 0.0f;
    private Date navCalculationTime;
    public static final String COMMA = ",";
    public static final String SEMI_COLON = ";";
    public static final String TERMINATOR = "END_MESSEGE";
    public static final String IN_TIME_FORMAT = "HHmmss";
    public static final String TIME_FORMAT = "HH:mm:ss";

    public INAV(String exchange, String country, String eftCode, long volume, float lastTradePrice, float inav, String navCalculationTime) {
        this.setIdentifier(5);
        this.country = country;
        this.exchange = exchange;
        this.eftCode = eftCode;
        this.volume = volume;
        this.lastTradePrice = lastTradePrice;
        this.inav = inav;
        this.navCalculationTime = this.formatPSXTime(navCalculationTime);
    }

    public INAV(String feed) {
        try {
            StringTokenizer tokenizer = new StringTokenizer(feed, COMMA);
            this.setCountry(tokenizer.nextToken());
            this.setExchange(tokenizer.nextToken());
            this.setIdentifier(tokenizer.nextToken());
            this.setTimeStamp(this.formatDate(tokenizer.nextToken()));
            this.setNavCalculationTime(this.formatTime(tokenizer.nextToken()));
            this.setEftCode(tokenizer.nextToken());
            this.setVolume(Utility.parseInt(tokenizer.nextToken(), 0));
            this.setLastTradePrice(Utility.parseFloat(tokenizer.nextToken(), 0.0f));
            this.setInav(Utility.parseFloat(tokenizer.nextToken(), 0.0f));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public Date formatDate(String date) {
        SimpleDateFormat df;
        block3: {
            try {
                df = new SimpleDateFormat("yyyyMMddHHmmss");
                df.setLenient(false);
                if (!date.equals(" ") && !date.equals("")) break block3;
                return null;
            }
            catch (ParseException pe) {
                System.out.println("Unable to parse date:'" + date + "' " + pe.getMessage());
                return null;
            }
        }
        return df.parse(date);
    }

    public Date formatPSXTime(String date) {
        SimpleDateFormat df;
        block3: {
            try {
                df = new SimpleDateFormat(IN_TIME_FORMAT);
                df.setLenient(false);
                if (!date.equals(" ") && !date.equals("")) break block3;
                return null;
            }
            catch (ParseException pe) {
                System.out.println("Unable to parse date:'" + date + "' " + pe.getMessage());
                return null;
            }
        }
        return df.parse(date);
    }

    public Date formatTime(String date) {
        SimpleDateFormat df;
        block3: {
            try {
                df = new SimpleDateFormat(TIME_FORMAT);
                df.setLenient(false);
                if (!date.equals(" ") && !date.equals("")) break block3;
                return null;
            }
            catch (ParseException pe) {
                System.out.println("Unable to parse date:'" + date + "' " + pe.getMessage());
                return null;
            }
        }
        return df.parse(date);
    }

    public String formatTime(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(TIME_FORMAT);
        df.setLenient(false);
        if (date == null) {
            return " ";
        }
        return df.format(date);
    }

    @Override
    public String getExchange() {
        return this.exchange;
    }

    @Override
    public void setExchange(String exchange) {
        this.exchange = exchange;
    }

    public String getEftCode() {
        return this.eftCode;
    }

    public void setEftCode(String eftCode) {
        this.eftCode = eftCode;
    }

    public long getVolume() {
        return this.volume;
    }

    public void setVolume(long volume) {
        this.volume = volume;
    }

    public float getLastTradePrice() {
        return this.lastTradePrice;
    }

    public void setLastTradePrice(float lastTradePrice) {
        this.lastTradePrice = lastTradePrice;
    }

    public float getInav() {
        return this.inav;
    }

    public void setInav(float inav) {
        this.inav = inav;
    }

    public Date getNavCalculationTime() {
        return this.navCalculationTime;
    }

    public void setNavCalculationTime(Date navCalculationTime) {
        this.navCalculationTime = navCalculationTime;
    }

    public String formatString() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        df.setLenient(false);
        return String.valueOf(this.country) + COMMA + this.exchange + COMMA + "INAV" + COMMA + df.format(this.timeStamp) + COMMA + this.formatTime(this.navCalculationTime) + COMMA + this.eftCode + COMMA + this.formatInt(this.volume) + COMMA + this.formatFloat(this.lastTradePrice) + COMMA + this.formatFloat(this.inav) + COMMA + TERMINATOR + COMMA;
    }

    private String[] getTokens(String str, String delimiter) {
        String[] tokenArray = null;
        StringTokenizer st = new StringTokenizer(str, delimiter);
        int tokenCount = st.countTokens();
        tokenArray = new String[tokenCount];
        int i = 0;
        while (i < tokenCount) {
            tokenArray[i] = st.nextToken();
            ++i;
        }
        return tokenArray;
    }

    public String formatFloat(float number) {
        if (number == 0.0f) {
            return " ";
        }
        return "" + number;
    }

    public String formatInt(long number) {
        if (number == 0L) {
            return " ";
        }
        return "" + number;
    }
}

