/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

public class GraphData
implements Serializable {
    private static final long serialVersionUID = 100023L;
    protected Date timeStamp;
    protected float price;
    protected float open;
    protected float high;
    protected float low;
    protected float close;
    protected long turnover;
    public static final String TAG_timeStamp = "STM";
    public static final String TAG_price = "PRC";

    public GraphData(Date timeStamp, float price) {
        this.setTimeStamp(timeStamp);
        this.setPrice(price);
        this.setOpen(price);
        this.setHigh(price);
        this.setLow(price);
        this.setClose(price);
        this.setTurnover(0L);
    }

    public GraphData(Date timeStamp, float price, float open, float high, float low, float close, long turnover) {
        this.setTimeStamp(timeStamp);
        this.setPrice(price);
        this.setOpen(open);
        this.setHigh(high);
        this.setLow(low);
        this.setClose(close);
        this.setTurnover(turnover);
    }

    public GraphData() {
    }

    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void setPrice(float price) {
        this.price = price;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public float getPrice() {
        return this.price;
    }

    public void setOpen(float open) {
        this.open = open;
    }

    public float getOpen() {
        return this.open;
    }

    public void setHigh(float high) {
        this.high = high;
    }

    public float getHigh() {
        return this.high;
    }

    public void setLow(float low) {
        this.low = low;
    }

    public float getLow() {
        return this.low;
    }

    public void setClose(float close) {
        this.close = close;
    }

    public float getClose() {
        return this.close;
    }

    public void setTurnover(long turnover) {
        this.turnover = turnover;
    }

    public long getTurnover() {
        return this.turnover;
    }

    public String toXML() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        dateFormat.setLenient(false);
        return "<Class name=\"GraphData\"><STM>" + dateFormat.format(this.timeStamp) + "</" + TAG_timeStamp + ">" + "<" + TAG_price + ">" + this.price + "</" + TAG_price + ">" + "</Class>";
    }
}

