/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import pk.com.softech.messages.Message;
import pk.com.softech.messages.OrderMessage;

public class GlobalCancelRequest
extends Message {
    private static final long serialVersionUID = 100099L;
    private int filled = 0;
    private OrderMessage[] rows = null;
    public static final String TAG_filled = "FLD";
    public static final String TAG_rows = "ROW";

    public GlobalCancelRequest(int size) {
        super(0);
        this.rows = new OrderMessage[size];
    }

    public GlobalCancelRequest(OrderMessage[] rws) {
        if (rws != null) {
            this.rows = new OrderMessage[rws.length];
            System.arraycopy(rws, 0, this.rows, 0, rws.length);
            this.filled = rws.length;
        }
    }

    public int getFilled() {
        return this.filled;
    }

    public void addOrderMessage(OrderMessage data) throws ArrayIndexOutOfBoundsException {
        this.rows[this.filled++] = data;
    }

    public OrderMessage[] getRows() {
        return this.rows;
    }

    @Override
    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"GlobalCancelRequest\"><FLD>" + this.filled + "</" + TAG_filled + ">");
        int i = 0;
        while (i < this.filled) {
            if (this.rows[i] != null) {
                xml.append("<ROW>" + this.rows[i].toXML() + "</" + TAG_rows + ">");
            }
            ++i;
        }
        xml.append("</Class>");
        return xml.toString();
    }
}

