/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import java.io.Serializable;
import pk.com.softech.messages.ExchangeData;
import pk.com.softech.messages.INAV;
import pk.com.softech.messages.MBO;
import pk.com.softech.messages.MBP;
import pk.com.softech.messages.SymbolFeedData;

public class FeedData
implements Serializable {
    private static final long serialVersionUID = 100022L;
    ExchangeData exchangeData;
    SymbolFeedData symbolData;
    MBO mbo;
    MBP mbp;
    INAV inav;
    public static final String TAG_exchangeData = "EXD";
    public static final String TAG_symbolData = "SMD";
    public static final String TAG_mbo = "MBO";
    public static final String TAG_mbp = "MBP";
    public static final String TAG_inav = "INAV";

    public FeedData(ExchangeData exch, SymbolFeedData symbol, MBO mbo, MBP mbp) {
        this.setExchangeData(exch);
        this.setSymbolData(symbol);
        this.setMBO(mbo);
        this.setMBP(mbp);
    }

    public FeedData(INAV inav) {
        this.setInav(inav);
    }

    public FeedData(ExchangeData exch, SymbolFeedData symbol, MBO mbo) {
        this(exch, symbol, mbo, null);
    }

    public FeedData(ExchangeData exch, SymbolFeedData symbol) {
        this(exch, symbol, null);
    }

    public FeedData() {
    }

    public void setExchangeData(ExchangeData exch) {
        this.exchangeData = exch;
    }

    public void setSymbolData(SymbolFeedData symbol) {
        this.symbolData = symbol;
    }

    public void setMBO(MBO mbo) {
        this.mbo = mbo;
    }

    public void setMBP(MBP mbp) {
        this.mbp = mbp;
    }

    public ExchangeData getExchangeData() {
        return this.exchangeData;
    }

    public SymbolFeedData getSymbolData() {
        return this.symbolData;
    }

    public MBO getMBO() {
        return this.mbo;
    }

    public MBP getMBP() {
        return this.mbp;
    }

    public INAV getInav() {
        return this.inav;
    }

    public void setInav(INAV inav) {
        this.inav = inav;
    }

    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"FeedData\">");
        if (this.exchangeData != null) {
            xml.append("<EXD>" + this.exchangeData.toXML() + "</" + TAG_exchangeData + ">");
        }
        if (this.symbolData != null) {
            xml.append("<SMD>" + this.symbolData.toXML() + "</" + TAG_symbolData + ">");
        }
        if (this.mbo != null) {
            xml.append("<MBO>" + this.mbo.toXML() + "</" + TAG_mbo + ">");
        }
        if (this.mbp != null) {
            xml.append("<MBP>" + this.mbp.toXML() + "</" + TAG_mbp + ">");
        }
        xml.append("</Class>");
        return xml.toString();
    }
}

