/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import pk.com.softech.messages.Feed;

public class ExchangeData
extends Feed {
    private static final long serialVersionUID = 100018L;
    protected float currentIndex;
    protected float highIndex;
    protected float lowIndex;
    protected float lastIndex;
    protected long totalTrades;
    protected long totalTurnover;
    protected long monitoryVolume;
    protected long up;
    protected long down;
    protected long equal;
    protected float change;
    protected String symbol;
    protected long denominator;
    protected long multiplier;
    public static final String TAG_country = "CNT";
    public static final String TAG_exchange = "EXG";
    public static final String TAG_timeStamp = "TST";
    public static final String TAG_currentIndex = "CIN";
    public static final String TAG_highIndex = "HIN";
    public static final String TAG_lowIndex = "LIN";
    public static final String TAG_lastIndex = "LTI";
    public static final String TAG_totalTrades = "TLT";
    public static final String TAG_totalTurnover = "TTO";
    public static final String TAG_monitoryVolume = "MNV";
    public static final String TAG_up = "TUP";
    public static final String TAG_down = "DWN";
    public static final String TAG_equal = "EQU";
    public static final String TAG_change = "CHG";
    public static final String TAG_multiplier = "MUL";
    public static final String TAG_denominator = "DMT";
    public static final String KSE100 = "KSE100";
    public static final String LSE25 = "LSE-25";

    public ExchangeData(String country, String exchange, Date timeStamp, float currentIndex, float highIndex, float lowIndex, float lastIndex, long totalTrades, long totalTurnover, long monitoryVolume, long up, long down, long equal, float change) {
        this.setIdentifier(4);
        this.setCountry(country);
        this.setExchange(exchange);
        this.setTimeStamp(timeStamp);
        this.setCurrentIndex(currentIndex);
        this.setHighIndex(highIndex);
        this.setLowIndex(lowIndex);
        this.setLastIndex(lastIndex);
        this.setTotalTrades(totalTrades);
        this.setTotalTurnover(totalTurnover);
        this.setMonitoryVolume(monitoryVolume);
        this.setUp(up);
        this.setDown(down);
        this.setEqual(equal);
        this.setChange(change);
    }

    public ExchangeData(String feed) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            dateFormat.setLenient(false);
            StringTokenizer tokenizer = new StringTokenizer(feed, ",");
            this.setCountry(tokenizer.nextToken());
            this.setExchange(tokenizer.nextToken());
            this.setIdentifier(tokenizer.nextToken());
            this.setTimeStamp(dateFormat.parse(tokenizer.nextToken()));
            this.setCurrentIndex(Float.parseFloat(tokenizer.nextToken()));
            this.setHighIndex(Float.parseFloat(tokenizer.nextToken()));
            this.setLowIndex(Float.parseFloat(tokenizer.nextToken()));
            this.setLastIndex(Float.parseFloat(tokenizer.nextToken()));
            this.setTotalTrades(Long.parseLong(tokenizer.nextToken()));
            this.setTotalTurnover(Long.parseLong(tokenizer.nextToken()));
            this.setMonitoryVolume(Long.parseLong(tokenizer.nextToken()));
            this.setUp(Long.parseLong(tokenizer.nextToken()));
            this.setDown(Long.parseLong(tokenizer.nextToken()));
            this.setEqual(Long.parseLong(tokenizer.nextToken()));
            this.setSymbol(tokenizer.nextToken().trim().toUpperCase());
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public ExchangeData(String msg, String feed) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            dateFormat.setLenient(false);
            StringTokenizer tokenizer = new StringTokenizer(feed, ",");
            this.setCountry(tokenizer.nextToken());
            this.setExchange(tokenizer.nextToken());
            this.setIdentifier(tokenizer.nextToken());
            this.setTimeStamp(dateFormat.parse(tokenizer.nextToken()));
            this.setCurrentIndex(Float.parseFloat(tokenizer.nextToken()));
            this.setHighIndex(Float.parseFloat(tokenizer.nextToken()));
            this.setLowIndex(Float.parseFloat(tokenizer.nextToken()));
            this.setLastIndex(Float.parseFloat(tokenizer.nextToken()));
            this.setTotalTrades(Long.parseLong(tokenizer.nextToken()));
            this.setTotalTurnover(Long.parseLong(tokenizer.nextToken()));
            this.setMonitoryVolume(Long.parseLong(tokenizer.nextToken()));
            this.setDenominator(Long.parseLong(tokenizer.nextToken()));
            this.setMultiplier(Long.parseLong(tokenizer.nextToken()));
            this.setChange(Float.parseFloat(tokenizer.nextToken()));
            this.setSymbol(tokenizer.nextToken().trim().toUpperCase());
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public ExchangeData() {
        this.setIdentifier(4);
    }

    public void update(ExchangeData newFeed) {
        this.setCountry(newFeed.getCountry());
        this.setExchange(newFeed.getExchange());
        this.setTimeStamp(newFeed.getTimeStamp());
        if (newFeed.getCurrentIndex() > 0.0f) {
            this.setCurrentIndex(newFeed.getCurrentIndex());
        }
        if (newFeed.getHighIndex() > 0.0f) {
            this.setHighIndex(newFeed.getHighIndex());
        }
        if (newFeed.getLowIndex() > 0.0f) {
            this.setLowIndex(newFeed.getLowIndex());
        }
        if (newFeed.getLastIndex() > 0.0f) {
            this.setLastIndex(newFeed.getLastIndex());
        }
        if (newFeed.getTotalTrades() > 0L) {
            this.setTotalTrades(newFeed.getTotalTrades());
        }
        if (newFeed.getTotalTurnover() > 0L) {
            this.setTotalTurnover(newFeed.getTotalTurnover());
        }
        if (newFeed.getMonitoryVolume() > 0L) {
            this.setMonitoryVolume(newFeed.getMonitoryVolume());
        }
        this.setUp(newFeed.getUp());
        this.setDown(newFeed.getDown());
        this.setEqual(newFeed.getEqual());
        this.setChange(newFeed.getChange());
    }

    public void setCurrentIndex(float currentIndex) {
        this.currentIndex = currentIndex;
    }

    public void setHighIndex(float highIndex) {
        this.highIndex = highIndex;
    }

    public void setLowIndex(float lowIndex) {
        this.lowIndex = lowIndex;
    }

    public void setLastIndex(float lastIndex) {
        this.lastIndex = lastIndex;
    }

    public void setTotalTrades(long totalTrades) {
        this.totalTrades = totalTrades;
    }

    public void setTotalTurnover(long totalTurnover) {
        this.totalTurnover = totalTurnover;
    }

    public void setMonitoryVolume(long monitoryVolume) {
        this.monitoryVolume = monitoryVolume;
    }

    public void setUp(long up) {
        this.up = up;
    }

    public void setDown(long down) {
        this.down = down;
    }

    public void setEqual(long equal) {
        this.equal = equal;
    }

    public void setChange(float change) {
        this.change = change;
    }

    public float getCurrentIndex() {
        return this.currentIndex;
    }

    public float getHighIndex() {
        return this.highIndex;
    }

    public float getLowIndex() {
        return this.lowIndex;
    }

    public float getLastIndex() {
        return this.lastIndex;
    }

    public long getTotalTrades() {
        return this.totalTrades;
    }

    public long getTotalTurnover() {
        return this.totalTurnover;
    }

    public long getMonitoryVolume() {
        return this.monitoryVolume;
    }

    public long getUp() {
        return this.up;
    }

    public long getDown() {
        return this.down;
    }

    public long getEqual() {
        return this.equal;
    }

    public float getChange() {
        return this.change;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol.trim().toUpperCase();
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setMultiplier(long multiplier) {
        this.multiplier = multiplier;
    }

    public long getMultiplier() {
        return this.multiplier;
    }

    public void setDenominator(long denominator) {
        this.denominator = denominator;
    }

    public long getDenominator() {
        return this.denominator;
    }

    public String formatString(String msg) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        df.setLenient(false);
        return String.valueOf(this.country) + "," + this.exchange + "," + "LLS" + "," + df.format(this.timeStamp) + "," + this.currentIndex + "," + this.highIndex + "," + this.lowIndex + "," + this.lastIndex + "," + this.totalTrades + "," + this.totalTurnover + "," + this.monitoryVolume + "," + this.denominator + "," + this.multiplier + "," + this.change + "," + this.symbol + "," + "END_MESSEGE" + ",";
    }

    public String formatString() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        df.setLenient(false);
        return String.valueOf(this.country) + "," + this.exchange + "," + "LLS" + "," + df.format(this.timeStamp) + "," + this.currentIndex + "," + this.highIndex + "," + this.lowIndex + "," + this.lastIndex + "," + this.totalTrades + "," + this.totalTurnover + "," + this.monitoryVolume + "," + this.up + "," + this.down + "," + this.equal + "," + this.symbol + "," + "END_MESSEGE" + ",";
    }

    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"ExchangeData\">");
        if (this.country != null && !this.country.equals("")) {
            xml.append("<CNT><![CDATA[" + this.country + "]]>" + "</" + TAG_country + ">");
        }
        if (this.exchange != null && !this.exchange.equals("")) {
            xml.append("<EXG><![CDATA[" + this.exchange + "]]>" + "</" + TAG_exchange + ">");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        dateFormat.setLenient(false);
        xml.append("<TST>" + dateFormat.format(this.timeStamp) + "</" + TAG_timeStamp + ">" + "<" + TAG_currentIndex + ">" + this.currentIndex + "</" + TAG_currentIndex + ">" + "<" + TAG_highIndex + ">" + this.highIndex + "</" + TAG_highIndex + ">" + "<" + TAG_lowIndex + ">" + this.lowIndex + "</" + TAG_lowIndex + ">" + "<" + TAG_lastIndex + ">" + this.lastIndex + "</" + TAG_lastIndex + ">" + "<" + TAG_totalTrades + ">" + this.totalTrades + "</" + TAG_totalTrades + ">" + "<" + TAG_totalTurnover + ">" + this.totalTurnover + "</" + TAG_totalTurnover + ">" + "<" + TAG_monitoryVolume + ">" + this.monitoryVolume + "</" + TAG_monitoryVolume + ">" + "<" + TAG_up + ">" + this.up + "</" + TAG_up + ">" + "<" + TAG_down + ">" + this.down + "</" + TAG_down + ">" + "<" + TAG_equal + ">" + this.equal + "</" + TAG_equal + ">" + "<" + TAG_change + ">" + this.change + "</" + TAG_change + ">" + "<" + TAG_denominator + ">" + this.denominator + "</" + TAG_denominator + ">" + "<" + TAG_multiplier + ">" + this.multiplier + "</" + TAG_multiplier + ">" + "</Class>");
        return xml.toString();
    }
}

