/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import java.io.Serializable;

public class ConnectedUsersData
implements Serializable {
    private static final long serialVersionUID = 100088L;
    protected int userType = -1;
    protected String userId = null;
    protected String terminalIP = null;
    protected String terminalName = null;
    protected String client = null;
    protected String trader = null;
    protected int applicationType = -1;
    protected String terminalVersion = "";
    private String serverName = "";
    public static final String TAG_userType = "UTY";
    public static final String TAG_userId = "UID";
    public static final String TAG_terminalIP = "TIP";
    public static final String TAG_terminalName = "TRN";
    public static final String TAG_client = "CLN";
    public static final String TAG_trader = "TRD";
    public static final String TAG_appType = "ATY";

    public ConnectedUsersData(int type, String id, String ip, String name, String cl, String tr) {
        this(type, id, ip, name, cl, tr, -1, "", "");
    }

    public ConnectedUsersData(int type, String id, String ip, String name, String cl, String tr, int appType) {
        this.setUserType(type);
        this.setUserId(id);
        this.setTerminalIP(ip);
        this.setTerminalName(name);
        this.setClient(cl);
        this.setTrader(tr);
        this.setApplicationType(appType);
    }

    public ConnectedUsersData(int type, String id, String ip, String name, String cl, String tr, int appType, String terminalVersion, String serverName) {
        this.setUserType(type);
        this.setUserId(id);
        this.setTerminalIP(ip);
        this.setTerminalName(name);
        this.setClient(cl);
        this.setTrader(tr);
        this.setApplicationType(appType);
        this.setTerminalVersion(terminalVersion);
        this.setServerName(serverName);
    }

    public ConnectedUsersData() {
    }

    public void setUserType(int type) {
        this.userType = type;
    }

    public void setUserId(String id) {
        this.userId = id;
    }

    public void setTerminalIP(String ip) {
        this.terminalIP = ip;
    }

    public void setTerminalName(String name) {
        this.terminalName = name;
    }

    public void setClient(String cl) {
        this.client = cl;
    }

    public void setTrader(String tr) {
        this.trader = tr;
    }

    public void setApplicationType(int type) {
        this.applicationType = type;
    }

    public int getUserType() {
        return this.userType;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getTerminalIP() {
        return this.terminalIP;
    }

    public String getTerminalName() {
        return this.terminalName;
    }

    public String getClient() {
        return this.client;
    }

    public String getTrader() {
        return this.trader;
    }

    public int getApplicationType() {
        return this.applicationType;
    }

    public void setTerminalVersion(String terminalVersion) {
        this.terminalVersion = terminalVersion;
    }

    public String getTerminalVersion() {
        return this.terminalVersion;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.userId == null ? 0 : this.userId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectedUsersData other = (ConnectedUsersData)obj;
        return !(this.userId == null ? other.userId != null : !this.userId.equals(other.userId));
    }

    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"ConnectedUsersData\"><UTY>" + this.userType + "</" + TAG_userType + ">");
        if (this.userId != null && !this.userId.equals("")) {
            xml.append("<UID><![CDATA[" + this.userId + "]]>" + "</" + TAG_userId + ">");
        }
        if (this.terminalIP != null && !this.terminalIP.equals("")) {
            xml.append("<TIP><![CDATA[" + this.terminalIP + "]]>" + "</" + TAG_terminalIP + ">");
        }
        if (this.terminalName != null && !this.terminalName.equals("")) {
            xml.append("<TRN><![CDATA[" + this.terminalName + "]]>" + "</" + TAG_terminalName + ">");
        }
        if (this.client != null && !this.client.equals("")) {
            xml.append("<CLN><![CDATA[" + this.client + "]]>" + "</" + TAG_client + ">");
        }
        if (this.trader != null && !this.trader.equals("")) {
            xml.append("<TRD><![CDATA[" + this.trader + "]]>" + "</" + TAG_trader + ">");
        }
        xml.append("<ATY>" + this.applicationType + "</" + TAG_appType + ">");
        xml.append("</Class>");
        return xml.toString();
    }
}

