/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import java.net.InetAddress;
import pk.com.softech.messages.Message;

public class ClientInfo
extends Message {
    private static final long serialVersionUID = 100006L;
    public static final int ADD = 0;
    public static final int REMOVE = 1;
    public static final int PING = 2;
    protected int action;
    protected String id;
    protected InetAddress address;
    protected int port;
    public static final String TAG_action = "ACT";
    public static final String TAG_id = "ID";
    public static final String TAG_address = "ADR";
    public static final String TAG_port = "PRT";
    private boolean pingFlag = true;

    public ClientInfo(String id, InetAddress address, int port, int action) {
        super(116);
        this.setId(id);
        this.setAddress(address);
        this.setPort(port);
        this.setAction(action);
    }

    public ClientInfo() {
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setAction(int action) {
        if (action == 0 || action == 1 || action == 2) {
            this.action = action;
        }
    }

    public String getId() {
        return this.id;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public int getAction() {
        return this.action;
    }

    public synchronized void setPingFlag(boolean bFlag) {
        this.pingFlag = bFlag;
    }

    public synchronized boolean getPingFlag() {
        return this.pingFlag;
    }

    public String toString() {
        return String.valueOf(this.address.getHostAddress()) + "/" + this.port + "/" + this.id;
    }

    @Override
    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"ClientInfo\"><ACT>" + this.action + "</" + TAG_action + ">");
        if (this.id != null && !this.id.equals("")) {
            xml.append("<ID><![CDATA[" + this.id + "]]>" + "</" + TAG_id + ">");
        }
        xml.append("<PRT>" + this.port + "</" + TAG_port + ">" + "</Class>");
        return xml.toString();
    }
}

