/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import pk.com.softech.messages.Message;

public class COTTransactionResponse
extends Message {
    private static final long serialVersionUID = 100017L;
    public static final int PLACE_COT_ORDER = 1;
    public static final int DISTRIBUTE_COT = 2;
    public static final int SUCCESSFUL = 1;
    public static final int FAILED = 2;
    protected int cotRequestNo;
    protected int action;
    protected String remarks;
    public static final String TAG_cotRequestNo = "CRN";
    public static final String TAG_action = "ACT";
    public static final String TAG_remarks = "REM";

    public COTTransactionResponse(int cotRequestType, int act, String rem) {
        super(0);
        this.setCOTRequestType(cotRequestType);
        this.setAction(act);
        this.setRemarks(rem);
    }

    public COTTransactionResponse() {
        super(0);
    }

    public void setCOTRequestType(int cotRequestType) {
        switch (cotRequestType) {
            case 1: 
            case 2: {
                this.cotRequestNo = cotRequestType;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid cot transaction request type.");
            }
        }
    }

    public int getCOTRequestType() {
        return this.cotRequestNo;
    }

    public void setAction(int act) {
        switch (act) {
            case 1: 
            case 2: {
                this.action = act;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid cot response action.");
            }
        }
    }

    public int getAction() {
        return this.action;
    }

    public void setRemarks(String rem) {
        this.remarks = rem;
    }

    public String getRemarks() {
        return this.remarks;
    }

    @Override
    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"COTTransactionResponse\"><CRN>" + this.cotRequestNo + "</" + TAG_cotRequestNo + ">" + "<" + TAG_action + ">" + this.action + "</" + TAG_action + ">");
        if (this.remarks != null && !this.remarks.equals("")) {
            xml.append("<REM><![CDATA[" + this.remarks + "]]>" + "</" + TAG_remarks + ">");
        }
        xml.append("</Class>");
        return xml.toString();
    }
}

