/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import pk.com.softech.messages.COTData;
import pk.com.softech.messages.Message;

public class COTPositionResponse
extends Message {
    private static final long serialVersionUID = 100015L;
    String userId;
    COTData[] rows;
    int filled;
    public static final String TAG_userId = "UID";
    public static final String TAG_rows = "ROW";
    public static final String TAG_filled = "FLD";

    public COTPositionResponse(int size) {
        super(415);
        this.rows = new COTData[size];
        this.filled = 0;
        this.userId = null;
    }

    public COTPositionResponse(COTData[] rws) {
        super(415);
        this.filled = 0;
        if (rws != null) {
            this.rows = new COTData[rws.length];
            this.filled = rws.length;
            System.arraycopy(rws, 0, this.rows, 0, rws.length);
        }
        this.userId = null;
    }

    public void addCOT(COTData data) throws ArrayIndexOutOfBoundsException {
        this.rows[this.filled++] = data;
    }

    public void setUserId(String uid) {
        this.userId = uid;
    }

    public String getUserId() {
        return this.userId;
    }

    public COTData[] getRows() {
        return this.rows;
    }

    public int getFilled() {
        return this.filled;
    }

    public String formatString() {
        return "";
    }

    @Override
    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"COTPositionResponse\"><FLD>" + this.filled + "</" + TAG_filled + ">");
        if (this.userId != null && !this.userId.equals("")) {
            xml.append("<UID><![CDATA[" + this.userId + "]]>" + "</" + TAG_userId + ">");
        }
        int i = 0;
        while (i < this.filled) {
            if (this.rows[i] != null) {
                xml.append("<ROW>" + this.rows[i].toXML() + "</" + TAG_rows + ">");
            }
            ++i;
        }
        xml.append("</Class>");
        return xml.toString();
    }
}

